/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.shardingsphere.migration.distsql.statement.pojo;

import lombok.Getter;
import lombok.RequiredArgsConstructor;
import org.apache.shardingsphere.infra.datanode.DataNode;

import java.util.Objects;

/**
 * Source target entry.
 */
@RequiredArgsConstructor
@Getter
public final class SourceTargetEntry {
    
    private final String targetDatabaseName;
    
    private final DataNode source;
    
    private final String targetTableName;
    
    @Override
    public boolean equals(final Object object) {
        if (this == object) {
            return true;
        }
        if (null == object || getClass() != object.getClass()) {
            return false;
        }
        final SourceTargetEntry that = (SourceTargetEntry) object;
        return source.equals(that.source) && targetTableName.equals(that.targetTableName);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(source, targetTableName);
    }
}
