/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.distsql.parser.core;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.segment.DatabaseDiscoveryRuleSegment;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.AlterDatabaseDiscoveryRuleStatement;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.CountDatabaseDiscoveryRuleStatement;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.CreateDatabaseDiscoveryRuleStatement;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.DropDatabaseDiscoveryHeartbeatStatement;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.DropDatabaseDiscoveryRuleStatement;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.DropDatabaseDiscoveryTypeStatement;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.ShowDatabaseDiscoveryHeartbeatsStatement;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.ShowDatabaseDiscoveryRulesStatement;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.ShowDatabaseDiscoveryTypesStatement;
import org.apache.shardingsphere.distsql.parser.autogen.DatabaseDiscoveryDistSQLStatementBaseVisitor;
import org.apache.shardingsphere.distsql.parser.autogen.DatabaseDiscoveryDistSQLStatementParser;
import org.apache.shardingsphere.distsql.parser.segment.AlgorithmSegment;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.SQLVisitor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.DatabaseSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class DatabaseDiscoveryDistSQLStatementVisitor
extends DatabaseDiscoveryDistSQLStatementBaseVisitor<ASTNode>
implements SQLVisitor {
    @Override
    public ASTNode visitCreateDatabaseDiscoveryRule(DatabaseDiscoveryDistSQLStatementParser.CreateDatabaseDiscoveryRuleContext ctx) {
        return new CreateDatabaseDiscoveryRuleStatement(null != ctx.ifNotExists(), (Collection)ctx.databaseDiscoveryRule().stream().map(each -> (DatabaseDiscoveryRuleSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitAlterDatabaseDiscoveryRule(DatabaseDiscoveryDistSQLStatementParser.AlterDatabaseDiscoveryRuleContext ctx) {
        return new AlterDatabaseDiscoveryRuleStatement((Collection)ctx.databaseDiscoveryRule().stream().map(each -> (DatabaseDiscoveryRuleSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitDatabaseDiscoveryRule(DatabaseDiscoveryDistSQLStatementParser.DatabaseDiscoveryRuleContext ctx) {
        return new DatabaseDiscoveryRuleSegment(this.getIdentifierValue((ParseTree)ctx.ruleName()), this.buildResources(ctx.storageUnits()), (AlgorithmSegment)this.visit((ParseTree)ctx.algorithmDefinition()), this.getProperties(ctx.discoveryHeartbeat().propertiesDefinition()));
    }

    private List<String> buildResources(DatabaseDiscoveryDistSQLStatementParser.StorageUnitsContext ctx) {
        return ctx.storageUnitName().stream().map(each -> new IdentifierValue(each.getText()).getValue()).collect(Collectors.toList());
    }

    @Override
    public ASTNode visitDropDatabaseDiscoveryRule(DatabaseDiscoveryDistSQLStatementParser.DropDatabaseDiscoveryRuleContext ctx) {
        return new DropDatabaseDiscoveryRuleStatement(null != ctx.ifExists(), (Collection)ctx.ruleName().stream().map(this::getIdentifierValue).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitShowDatabaseDiscoveryRules(DatabaseDiscoveryDistSQLStatementParser.ShowDatabaseDiscoveryRulesContext ctx) {
        return new ShowDatabaseDiscoveryRulesStatement(null == ctx.ruleName() ? null : this.getIdentifierValue((ParseTree)ctx.ruleName()), null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
    }

    @Override
    public ASTNode visitAlgorithmDefinition(DatabaseDiscoveryDistSQLStatementParser.AlgorithmDefinitionContext ctx) {
        return new AlgorithmSegment(this.getIdentifierValue((ParseTree)ctx.algorithmTypeName()), this.getProperties(ctx.propertiesDefinition()));
    }

    @Override
    public ASTNode visitShowDatabaseDiscoveryTypes(DatabaseDiscoveryDistSQLStatementParser.ShowDatabaseDiscoveryTypesContext ctx) {
        return new ShowDatabaseDiscoveryTypesStatement(null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
    }

    @Override
    public ASTNode visitShowDatabaseDiscoveryHeartbeats(DatabaseDiscoveryDistSQLStatementParser.ShowDatabaseDiscoveryHeartbeatsContext ctx) {
        return new ShowDatabaseDiscoveryHeartbeatsStatement(null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
    }

    private String getIdentifierValue(ParseTree context) {
        return null == context ? null : new IdentifierValue(context.getText()).getValue();
    }

    @Override
    public ASTNode visitDatabaseName(DatabaseDiscoveryDistSQLStatementParser.DatabaseNameContext ctx) {
        return new DatabaseSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), new IdentifierValue(ctx.getText()));
    }

    @Override
    public ASTNode visitDropDatabaseDiscoveryType(DatabaseDiscoveryDistSQLStatementParser.DropDatabaseDiscoveryTypeContext ctx) {
        return new DropDatabaseDiscoveryTypeStatement(null != ctx.ifExists(), (Collection)ctx.discoveryTypeName().stream().map(this::getIdentifierValue).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitDropDatabaseDiscoveryHeartbeat(DatabaseDiscoveryDistSQLStatementParser.DropDatabaseDiscoveryHeartbeatContext ctx) {
        return new DropDatabaseDiscoveryHeartbeatStatement(null != ctx.ifExists(), (Collection)ctx.discoveryHeartbeatName().stream().map(this::getIdentifierValue).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitCountDatabaseDiscoveryRule(DatabaseDiscoveryDistSQLStatementParser.CountDatabaseDiscoveryRuleContext ctx) {
        return new CountDatabaseDiscoveryRuleStatement(Objects.nonNull((Object)ctx.databaseName()) ? (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()) : null);
    }

    private Properties getProperties(DatabaseDiscoveryDistSQLStatementParser.PropertiesDefinitionContext ctx) {
        Properties result = new Properties();
        if (null == ctx || null == ctx.properties()) {
            return result;
        }
        for (DatabaseDiscoveryDistSQLStatementParser.PropertyContext each : ctx.properties().property()) {
            result.setProperty(IdentifierValue.getQuotedContent((String)each.key.getText()), IdentifierValue.getQuotedContent((String)each.value.getText()));
        }
        return result;
    }
}

