/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.distsql.parser.segment;

import com.google.common.base.Strings;
import lombok.Generated;
import org.apache.shardingsphere.distsql.parser.segment.AlgorithmSegment;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;

public final class EncryptColumnSegment
implements ASTNode {
    private final String name;
    private final String cipherColumn;
    private final String plainColumn;
    private final String assistedQueryColumn;
    private final String likeQueryColumn;
    private String dataType;
    private String cipherDataType;
    private String plainDataType;
    private String assistedQueryDataType;
    private String likeQueryDataType;
    private final AlgorithmSegment encryptor;
    private final AlgorithmSegment assistedQueryEncryptor;
    private final AlgorithmSegment likeQueryEncryptor;
    private final Boolean queryWithCipherColumn;

    public boolean isCorrectDataType() {
        boolean requireDataType = !Strings.isNullOrEmpty((String)this.dataType);
        return this.isCorrectDataType(requireDataType, this.name, this.dataType) && this.isCorrectDataType(requireDataType, this.plainColumn, this.plainDataType) && this.isCorrectDataType(requireDataType, this.cipherColumn, this.cipherDataType) && this.isCorrectDataType(requireDataType, this.assistedQueryColumn, this.assistedQueryDataType) && this.isCorrectDataType(requireDataType, this.likeQueryColumn, this.likeQueryDataType);
    }

    private boolean isCorrectDataType(boolean requireDataType, String field, String fieldDataType) {
        boolean noDataTypeRequired = !requireDataType && Strings.isNullOrEmpty((String)fieldDataType);
        boolean requireDataTypeAndFieldExisted = requireDataType && !Strings.isNullOrEmpty((String)field) && !Strings.isNullOrEmpty((String)fieldDataType);
        boolean requireDataTypeAndFieldNotExisted = requireDataType && Strings.isNullOrEmpty((String)field) && Strings.isNullOrEmpty((String)fieldDataType);
        return noDataTypeRequired || requireDataTypeAndFieldExisted || requireDataTypeAndFieldNotExisted;
    }

    @Generated
    public EncryptColumnSegment(String name, String cipherColumn, String plainColumn, String assistedQueryColumn, String likeQueryColumn, String dataType, String cipherDataType, String plainDataType, String assistedQueryDataType, String likeQueryDataType, AlgorithmSegment encryptor, AlgorithmSegment assistedQueryEncryptor, AlgorithmSegment likeQueryEncryptor, Boolean queryWithCipherColumn) {
        this.name = name;
        this.cipherColumn = cipherColumn;
        this.plainColumn = plainColumn;
        this.assistedQueryColumn = assistedQueryColumn;
        this.likeQueryColumn = likeQueryColumn;
        this.dataType = dataType;
        this.cipherDataType = cipherDataType;
        this.plainDataType = plainDataType;
        this.assistedQueryDataType = assistedQueryDataType;
        this.likeQueryDataType = likeQueryDataType;
        this.encryptor = encryptor;
        this.assistedQueryEncryptor = assistedQueryEncryptor;
        this.likeQueryEncryptor = likeQueryEncryptor;
        this.queryWithCipherColumn = queryWithCipherColumn;
    }

    @Generated
    public EncryptColumnSegment(String name, String cipherColumn, String plainColumn, String assistedQueryColumn, String likeQueryColumn, AlgorithmSegment encryptor, AlgorithmSegment assistedQueryEncryptor, AlgorithmSegment likeQueryEncryptor, Boolean queryWithCipherColumn) {
        this.name = name;
        this.cipherColumn = cipherColumn;
        this.plainColumn = plainColumn;
        this.assistedQueryColumn = assistedQueryColumn;
        this.likeQueryColumn = likeQueryColumn;
        this.encryptor = encryptor;
        this.assistedQueryEncryptor = assistedQueryEncryptor;
        this.likeQueryEncryptor = likeQueryEncryptor;
        this.queryWithCipherColumn = queryWithCipherColumn;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getCipherColumn() {
        return this.cipherColumn;
    }

    @Generated
    public String getPlainColumn() {
        return this.plainColumn;
    }

    @Generated
    public String getAssistedQueryColumn() {
        return this.assistedQueryColumn;
    }

    @Generated
    public String getLikeQueryColumn() {
        return this.likeQueryColumn;
    }

    @Generated
    public String getDataType() {
        return this.dataType;
    }

    @Generated
    public String getCipherDataType() {
        return this.cipherDataType;
    }

    @Generated
    public String getPlainDataType() {
        return this.plainDataType;
    }

    @Generated
    public String getAssistedQueryDataType() {
        return this.assistedQueryDataType;
    }

    @Generated
    public String getLikeQueryDataType() {
        return this.likeQueryDataType;
    }

    @Generated
    public AlgorithmSegment getEncryptor() {
        return this.encryptor;
    }

    @Generated
    public AlgorithmSegment getAssistedQueryEncryptor() {
        return this.assistedQueryEncryptor;
    }

    @Generated
    public AlgorithmSegment getLikeQueryEncryptor() {
        return this.likeQueryEncryptor;
    }

    @Generated
    public Boolean getQueryWithCipherColumn() {
        return this.queryWithCipherColumn;
    }
}

