/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.parser.core;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.distsql.parser.autogen.ShardingDistSQLStatementBaseVisitor;
import org.apache.shardingsphere.distsql.parser.autogen.ShardingDistSQLStatementParser;
import org.apache.shardingsphere.distsql.parser.segment.AlgorithmSegment;
import org.apache.shardingsphere.sharding.distsql.parser.segment.strategy.AuditStrategySegment;
import org.apache.shardingsphere.sharding.distsql.parser.segment.strategy.KeyGenerateStrategySegment;
import org.apache.shardingsphere.sharding.distsql.parser.segment.strategy.ShardingAuditorSegment;
import org.apache.shardingsphere.sharding.distsql.parser.segment.strategy.ShardingStrategySegment;
import org.apache.shardingsphere.sharding.distsql.parser.segment.table.AbstractTableRuleSegment;
import org.apache.shardingsphere.sharding.distsql.parser.segment.table.AutoTableRuleSegment;
import org.apache.shardingsphere.sharding.distsql.parser.segment.table.TableReferenceRuleSegment;
import org.apache.shardingsphere.sharding.distsql.parser.segment.table.TableRuleSegment;
import org.apache.shardingsphere.sharding.distsql.parser.statement.AlterDefaultShardingStrategyStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.AlterShardingTableReferenceRuleStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.AlterShardingTableRuleStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.CountShardingRuleStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.CreateBroadcastTableRuleStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.CreateDefaultShardingStrategyStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.CreateShardingTableReferenceRuleStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.CreateShardingTableRuleStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.DropBroadcastTableRuleStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.DropDefaultShardingStrategyStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.DropShardingAlgorithmStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.DropShardingAuditorStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.DropShardingKeyGeneratorStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.DropShardingTableReferenceRuleStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.DropShardingTableRuleStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.ShowBroadcastTableRulesStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.ShowDefaultShardingStrategyStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.ShowShardingAlgorithmsStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.ShowShardingAuditorsStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.ShowShardingKeyGeneratorsStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.ShowShardingTableNodesStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.ShowShardingTableReferenceRulesStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.ShowShardingTableRulesStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.ShowShardingTableRulesUsedAlgorithmStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.ShowShardingTableRulesUsedAuditorStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.ShowShardingTableRulesUsedKeyGeneratorStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.ShowUnusedShardingAlgorithmsStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.ShowUnusedShardingAuditorsStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.ShowUnusedShardingKeyGeneratorsStatement;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.SQLVisitor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.DatabaseSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class ShardingDistSQLStatementVisitor
extends ShardingDistSQLStatementBaseVisitor<ASTNode>
implements SQLVisitor {
    @Override
    public ASTNode visitCreateShardingTableRule(ShardingDistSQLStatementParser.CreateShardingTableRuleContext ctx) {
        Collection tableRuleSegments = ctx.shardingTableRuleDefinition().stream().map(each -> (AbstractTableRuleSegment)this.visit((ParseTree)each)).filter(Objects::nonNull).collect(Collectors.toList());
        return new CreateShardingTableRuleStatement(null != ctx.ifNotExists(), tableRuleSegments);
    }

    @Override
    public ASTNode visitCreateShardingTableReferenceRule(ShardingDistSQLStatementParser.CreateShardingTableReferenceRuleContext ctx) {
        return new CreateShardingTableReferenceRuleStatement(null != ctx.ifNotExists(), this.getTableReferenceRuleSegments(ctx.tableReferenceRuleDefinition()));
    }

    private Collection<TableReferenceRuleSegment> getTableReferenceRuleSegments(List<ShardingDistSQLStatementParser.TableReferenceRuleDefinitionContext> ctx) {
        LinkedList<TableReferenceRuleSegment> result = new LinkedList<TableReferenceRuleSegment>();
        for (ShardingDistSQLStatementParser.TableReferenceRuleDefinitionContext each : ctx) {
            String ruleName = this.getIdentifierValue((ParseTree)each.ruleName());
            String reference = each.tableName().stream().map(this::getIdentifierValue).collect(Collectors.joining(","));
            result.add(new TableReferenceRuleSegment(ruleName, reference));
        }
        return result;
    }

    @Override
    public ASTNode visitCreateBroadcastTableRule(ShardingDistSQLStatementParser.CreateBroadcastTableRuleContext ctx) {
        return new CreateBroadcastTableRuleStatement(null != ctx.ifNotExists(), (Collection)ctx.tableName().stream().map(this::getIdentifierValue).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitAlterShardingTableRule(ShardingDistSQLStatementParser.AlterShardingTableRuleContext ctx) {
        List tableRuleSegments = ctx.shardingTableRuleDefinition().stream().map(each -> (AbstractTableRuleSegment)this.visit((ParseTree)each)).filter(Objects::nonNull).collect(Collectors.toList());
        return new AlterShardingTableRuleStatement(tableRuleSegments);
    }

    @Override
    public ASTNode visitShowBroadcastTableRules(ShardingDistSQLStatementParser.ShowBroadcastTableRulesContext ctx) {
        return new ShowBroadcastTableRulesStatement(null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
    }

    @Override
    public ASTNode visitAlterShardingTableReferenceRule(ShardingDistSQLStatementParser.AlterShardingTableReferenceRuleContext ctx) {
        return new AlterShardingTableReferenceRuleStatement(this.getTableReferenceRuleSegments(ctx.tableReferenceRuleDefinition()));
    }

    @Override
    public ASTNode visitDropShardingTableRule(ShardingDistSQLStatementParser.DropShardingTableRuleContext ctx) {
        return new DropShardingTableRuleStatement(null != ctx.ifExists(), (Collection)ctx.tableName().stream().map(each -> (TableNameSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitDropShardingTableReferenceRule(ShardingDistSQLStatementParser.DropShardingTableReferenceRuleContext ctx) {
        return new DropShardingTableReferenceRuleStatement(null != ctx.ifExists(), (Collection)ctx.ruleName().stream().map(this::getIdentifierValue).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitCreateDefaultShardingStrategy(ShardingDistSQLStatementParser.CreateDefaultShardingStrategyContext ctx) {
        ShardingDistSQLStatementParser.ShardingStrategyContext shardingStrategyContext = ctx.shardingStrategy();
        String strategyType = this.getIdentifierValue((ParseTree)shardingStrategyContext.strategyType());
        String defaultType = new IdentifierValue(ctx.type.getText()).getValue();
        if ("none".equalsIgnoreCase(strategyType)) {
            return new CreateDefaultShardingStrategyStatement(null != ctx.ifNotExists(), defaultType, "none", null, null);
        }
        AlgorithmSegment algorithmSegment = null != shardingStrategyContext.shardingAlgorithm().algorithmDefinition() ? (AlgorithmSegment)this.visitAlgorithmDefinition(shardingStrategyContext.shardingAlgorithm().algorithmDefinition()) : null;
        String shardingColumn = null != ctx.shardingStrategy().shardingColumnDefinition() ? this.buildShardingColumn(ctx.shardingStrategy().shardingColumnDefinition()) : null;
        return new CreateDefaultShardingStrategyStatement(null != ctx.ifNotExists(), defaultType, strategyType, shardingColumn, algorithmSegment);
    }

    @Override
    public ASTNode visitAlterDefaultShardingStrategy(ShardingDistSQLStatementParser.AlterDefaultShardingStrategyContext ctx) {
        String defaultType = new IdentifierValue(ctx.type.getText()).getValue();
        String strategyType = this.getIdentifierValue((ParseTree)ctx.shardingStrategy().strategyType());
        if ("none".equalsIgnoreCase(strategyType)) {
            return new AlterDefaultShardingStrategyStatement(defaultType, "none", null, null);
        }
        String shardingColumn = this.buildShardingColumn(ctx.shardingStrategy().shardingColumnDefinition());
        AlgorithmSegment algorithmSegment = null == ctx.shardingStrategy().shardingAlgorithm().algorithmDefinition() ? null : (AlgorithmSegment)this.visitAlgorithmDefinition(ctx.shardingStrategy().shardingAlgorithm().algorithmDefinition());
        return new AlterDefaultShardingStrategyStatement(defaultType, strategyType, shardingColumn, algorithmSegment);
    }

    @Override
    public ASTNode visitDropDefaultShardingStrategy(ShardingDistSQLStatementParser.DropDefaultShardingStrategyContext ctx) {
        return new DropDefaultShardingStrategyStatement(null != ctx.ifExists(), new IdentifierValue(ctx.type.getText()).getValue().toLowerCase());
    }

    @Override
    public ASTNode visitDropBroadcastTableRule(ShardingDistSQLStatementParser.DropBroadcastTableRuleContext ctx) {
        Collection tableNames = ctx.tableName().stream().map(this::getIdentifierValue).collect(Collectors.toList());
        return new DropBroadcastTableRuleStatement(null != ctx.ifExists(), tableNames);
    }

    @Override
    public ASTNode visitDropShardingAlgorithm(ShardingDistSQLStatementParser.DropShardingAlgorithmContext ctx) {
        return new DropShardingAlgorithmStatement(null != ctx.ifExists(), (Collection)ctx.shardingAlgorithmName().stream().map(this::getIdentifierValue).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitShowShardingTableRules(ShardingDistSQLStatementParser.ShowShardingTableRulesContext ctx) {
        return new ShowShardingTableRulesStatement(null == ctx.tableRule() ? null : this.getIdentifierValue((ParseTree)ctx.tableRule().tableName()), null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
    }

    @Override
    public ASTNode visitShowShardingAlgorithms(ShardingDistSQLStatementParser.ShowShardingAlgorithmsContext ctx) {
        return new ShowShardingAlgorithmsStatement(Objects.nonNull((Object)ctx.databaseName()) ? (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()) : null);
    }

    @Override
    public ASTNode visitShardingTableRuleDefinition(ShardingDistSQLStatementParser.ShardingTableRuleDefinitionContext ctx) {
        if (null != ctx.shardingTableRule()) {
            return (ASTNode)this.visit((ParseTree)ctx.shardingTableRule());
        }
        if (null != ctx.shardingAutoTableRule()) {
            return (ASTNode)this.visit((ParseTree)ctx.shardingAutoTableRule());
        }
        return null;
    }

    @Override
    public ASTNode visitShardingTableRule(ShardingDistSQLStatementParser.ShardingTableRuleContext ctx) {
        KeyGenerateStrategySegment keyGenerateSegment = null == ctx.keyGenerateDefinition() ? null : (KeyGenerateStrategySegment)this.visit((ParseTree)ctx.keyGenerateDefinition());
        AuditStrategySegment auditStrategySegment = null == ctx.auditDefinition() ? null : (AuditStrategySegment)this.visitAuditDefinition(this.getIdentifierValue((ParseTree)ctx.tableName()), ctx.auditDefinition());
        TableRuleSegment result = new TableRuleSegment(this.getIdentifierValue((ParseTree)ctx.tableName()), this.getDataNodes(ctx.dataNodes()), keyGenerateSegment, auditStrategySegment);
        Optional.ofNullable(ctx.tableStrategy()).ifPresent(optional -> result.setTableStrategySegment((ShardingStrategySegment)this.visit((ParseTree)ctx.tableStrategy().shardingStrategy())));
        Optional.ofNullable(ctx.databaseStrategy()).ifPresent(optional -> result.setDatabaseStrategySegment((ShardingStrategySegment)this.visit((ParseTree)ctx.databaseStrategy().shardingStrategy())));
        return result;
    }

    private ASTNode visitAuditDefinition(String tableName, ShardingDistSQLStatementParser.AuditDefinitionContext ctx) {
        if (null == ctx) {
            return null;
        }
        LinkedList<ShardingAuditorSegment> shardingAuditorSegments = new LinkedList<ShardingAuditorSegment>();
        int index = 0;
        for (ShardingDistSQLStatementParser.SingleAuditDefinitionContext each : ctx.multiAuditDefinition().singleAuditDefinition()) {
            String algorithmTypeName = this.getIdentifierValue((ParseTree)each.algorithmDefinition().algorithmTypeName());
            String auditorName = String.format("%s_%s_%s", tableName, algorithmTypeName, index++).toLowerCase();
            shardingAuditorSegments.add(new ShardingAuditorSegment(auditorName, (AlgorithmSegment)this.visit((ParseTree)each.algorithmDefinition())));
        }
        return new AuditStrategySegment(shardingAuditorSegments, Boolean.parseBoolean(this.getIdentifierValue((ParseTree)ctx.auditAllowHintDisable())));
    }

    @Override
    public ASTNode visitShowShardingTableNodes(ShardingDistSQLStatementParser.ShowShardingTableNodesContext ctx) {
        return new ShowShardingTableNodesStatement(null == ctx.tableName() ? null : this.getIdentifierValue((ParseTree)ctx.tableName()), null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
    }

    @Override
    public ASTNode visitShardingAutoTableRule(ShardingDistSQLStatementParser.ShardingAutoTableRuleContext ctx) {
        AutoTableRuleSegment result = new AutoTableRuleSegment(this.getIdentifierValue((ParseTree)ctx.tableName()), this.getResources(ctx.storageUnits()));
        Optional.ofNullable(ctx.keyGenerateDefinition()).ifPresent(optional -> result.setKeyGenerateStrategySegment((KeyGenerateStrategySegment)this.visit((ParseTree)ctx.keyGenerateDefinition())));
        Optional.ofNullable(ctx.auditDefinition()).ifPresent(optional -> result.setAuditStrategySegment((AuditStrategySegment)this.visitAuditDefinition(this.getIdentifierValue((ParseTree)ctx.tableName()), ctx.auditDefinition())));
        Optional.ofNullable(ctx.autoShardingColumnDefinition()).ifPresent(optional -> result.setShardingColumn(this.buildShardingColumn(ctx.autoShardingColumnDefinition())));
        Optional.ofNullable(ctx.algorithmDefinition()).ifPresent(optional -> result.setShardingAlgorithmSegment((AlgorithmSegment)this.visit((ParseTree)ctx.algorithmDefinition())));
        return result;
    }

    @Override
    public ASTNode visitKeyGenerateDefinition(ShardingDistSQLStatementParser.KeyGenerateDefinitionContext ctx) {
        return null == ctx ? null : new KeyGenerateStrategySegment(this.getIdentifierValue((ParseTree)ctx.columnName()), (AlgorithmSegment)this.visit((ParseTree)ctx.algorithmDefinition()));
    }

    @Override
    public ASTNode visitShardingStrategy(ShardingDistSQLStatementParser.ShardingStrategyContext ctx) {
        String strategyType = this.getIdentifierValue((ParseTree)ctx.strategyType());
        if ("none".equalsIgnoreCase(strategyType)) {
            return new ShardingStrategySegment(strategyType, null, null);
        }
        AlgorithmSegment algorithmSegment = null != ctx.shardingAlgorithm().algorithmDefinition() ? (AlgorithmSegment)this.visitAlgorithmDefinition(ctx.shardingAlgorithm().algorithmDefinition()) : null;
        String shardingColumn = null != ctx.shardingColumnDefinition() ? this.buildShardingColumn(ctx.shardingColumnDefinition()) : null;
        return new ShardingStrategySegment(strategyType, shardingColumn, algorithmSegment);
    }

    private Collection<String> getResources(ShardingDistSQLStatementParser.StorageUnitsContext ctx) {
        return ctx.storageUnit().stream().map(this::getIdentifierValue).collect(Collectors.toList());
    }

    private Collection<String> getDataNodes(ShardingDistSQLStatementParser.DataNodesContext ctx) {
        return ctx.dataNode().stream().map(this::getIdentifierValueForDataNodes).collect(Collectors.toList());
    }

    @Override
    public ASTNode visitAlgorithmDefinition(ShardingDistSQLStatementParser.AlgorithmDefinitionContext ctx) {
        return new AlgorithmSegment(this.getIdentifierValue((ParseTree)ctx.algorithmTypeName()), this.getProperties(ctx.propertiesDefinition()));
    }

    private String getIdentifierValue(ParseTree context) {
        return null == context ? null : new IdentifierValue(context.getText()).getValue();
    }

    private String getIdentifierValueForDataNodes(ParseTree context) {
        if (null == context) {
            return null;
        }
        String value = new IdentifierValue(context.getText(), "[]'").getValue();
        return value.startsWith("'") ? value.substring(1, value.length() - 1) : value.trim();
    }

    private Properties getProperties(ShardingDistSQLStatementParser.PropertiesDefinitionContext ctx) {
        Properties result = new Properties();
        if (null == ctx || null == ctx.properties()) {
            return result;
        }
        for (ShardingDistSQLStatementParser.PropertyContext each : ctx.properties().property()) {
            result.setProperty(IdentifierValue.getQuotedContent((String)each.key.getText()), IdentifierValue.getQuotedContent((String)each.value.getText()));
        }
        return result;
    }

    @Override
    public ASTNode visitTableName(ShardingDistSQLStatementParser.TableNameContext ctx) {
        return new TableNameSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), new IdentifierValue(ctx.getText()));
    }

    @Override
    public ASTNode visitShowShardingTableReferenceRules(ShardingDistSQLStatementParser.ShowShardingTableReferenceRulesContext ctx) {
        return new ShowShardingTableReferenceRulesStatement(null == ctx.ruleName() ? null : this.getIdentifierValue((ParseTree)ctx.ruleName()), null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
    }

    @Override
    public ASTNode visitDatabaseName(ShardingDistSQLStatementParser.DatabaseNameContext ctx) {
        return new DatabaseSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), new IdentifierValue(ctx.getText()));
    }

    @Override
    public ASTNode visitShowShardingKeyGenerators(ShardingDistSQLStatementParser.ShowShardingKeyGeneratorsContext ctx) {
        return new ShowShardingKeyGeneratorsStatement(Objects.nonNull((Object)ctx.databaseName()) ? (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()) : null);
    }

    @Override
    public ASTNode visitDropShardingKeyGenerator(ShardingDistSQLStatementParser.DropShardingKeyGeneratorContext ctx) {
        return new DropShardingKeyGeneratorStatement(null != ctx.ifExists(), (Collection)ctx.keyGeneratorName().stream().map(this::getIdentifierValue).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitDropShardingAuditor(ShardingDistSQLStatementParser.DropShardingAuditorContext ctx) {
        return new DropShardingAuditorStatement(null != ctx.ifExists(), (Collection)ctx.auditorName().stream().map(this::getIdentifierValue).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitShowShardingAuditors(ShardingDistSQLStatementParser.ShowShardingAuditorsContext ctx) {
        return new ShowShardingAuditorsStatement(Objects.nonNull((Object)ctx.databaseName()) ? (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()) : null);
    }

    @Override
    public ASTNode visitShowDefaultShardingStrategy(ShardingDistSQLStatementParser.ShowDefaultShardingStrategyContext ctx) {
        return new ShowDefaultShardingStrategyStatement(Objects.nonNull((Object)ctx.databaseName()) ? (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()) : null);
    }

    @Override
    public ASTNode visitShowUnusedShardingAlgorithms(ShardingDistSQLStatementParser.ShowUnusedShardingAlgorithmsContext ctx) {
        return new ShowUnusedShardingAlgorithmsStatement(Objects.nonNull((Object)ctx.databaseName()) ? (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()) : null);
    }

    private String buildShardingColumn(ShardingDistSQLStatementParser.AutoShardingColumnDefinitionContext ctx) {
        return null == ctx.shardingColumn() ? null : this.getIdentifierValue((ParseTree)ctx.shardingColumn().columnName());
    }

    private String buildShardingColumn(ShardingDistSQLStatementParser.ShardingColumnDefinitionContext ctx) {
        String result = Optional.ofNullable(ctx.shardingColumn()).map(optional -> this.getIdentifierValue((ParseTree)optional.columnName())).orElseGet(() -> ctx.shardingColumns().columnName().stream().map(this::getIdentifierValue).collect(Collectors.joining(",")));
        return result.isEmpty() ? null : result;
    }

    @Override
    public ASTNode visitShowUnusedShardingKeyGenerators(ShardingDistSQLStatementParser.ShowUnusedShardingKeyGeneratorsContext ctx) {
        return new ShowUnusedShardingKeyGeneratorsStatement(Objects.nonNull((Object)ctx.databaseName()) ? (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()) : null);
    }

    @Override
    public ASTNode visitShowUnusedShardingAuditors(ShardingDistSQLStatementParser.ShowUnusedShardingAuditorsContext ctx) {
        return new ShowUnusedShardingAuditorsStatement(Objects.nonNull((Object)ctx.databaseName()) ? (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()) : null);
    }

    @Override
    public ASTNode visitShowShardingTableRulesUsedAlgorithm(ShardingDistSQLStatementParser.ShowShardingTableRulesUsedAlgorithmContext ctx) {
        return new ShowShardingTableRulesUsedAlgorithmStatement(this.getIdentifierValue((ParseTree)ctx.shardingAlgorithmName()), Objects.nonNull((Object)ctx.databaseName()) ? (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()) : null);
    }

    @Override
    public ASTNode visitShowShardingTableRulesUsedKeyGenerator(ShardingDistSQLStatementParser.ShowShardingTableRulesUsedKeyGeneratorContext ctx) {
        return new ShowShardingTableRulesUsedKeyGeneratorStatement(this.getIdentifierValue((ParseTree)ctx.keyGeneratorName()), null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
    }

    @Override
    public ASTNode visitShowShardingTableRulesUsedAuditor(ShardingDistSQLStatementParser.ShowShardingTableRulesUsedAuditorContext ctx) {
        return new ShowShardingTableRulesUsedAuditorStatement(this.getIdentifierValue((ParseTree)ctx.auditorName()), null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
    }

    @Override
    public ASTNode visitCountShardingRule(ShardingDistSQLStatementParser.CountShardingRuleContext ctx) {
        return new CountShardingRuleStatement(Objects.nonNull((Object)ctx.databaseName()) ? (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()) : null);
    }
}

