/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr;

import lombok.Getter;
import lombok.Setter;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;

/**
 * Xml processing instruction Function segment.
 */
@Getter
@Setter
public final class XmlPiFunctionSegment implements ExpressionSegment, ProjectionSegment {
    
    private final int startIndex;
    
    private final int stopIndex;
    
    private final String functionName;
    
    private final String identifier;
    
    private final ExpressionSegment evalNameValueExpr;
    
    private final ExpressionSegment valueExpr;
    
    private final String text;
    
    public XmlPiFunctionSegment(final int startIndex, final int stopIndex, final String functionName, final String identifier, final ExpressionSegment valueExpr, final String text) {
        this.startIndex = startIndex;
        this.stopIndex = stopIndex;
        this.functionName = functionName;
        this.evalNameValueExpr = null;
        this.identifier = identifier;
        this.valueExpr = valueExpr;
        this.text = text;
    }
    
    public XmlPiFunctionSegment(final int startIndex, final int stopIndex, final String functionName, final ExpressionSegment evalNameValueExpr, final ExpressionSegment valueExpr, final String text) {
        this.startIndex = startIndex;
        this.stopIndex = stopIndex;
        this.functionName = functionName;
        this.identifier = null;
        this.evalNameValueExpr = evalNameValueExpr;
        this.valueExpr = valueExpr;
        this.text = text;
    }
}
