/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.shardingsphere.test.it.sql.parser.internal.cases.parser.jaxb.segment.impl.distsql.rdl;

import lombok.Getter;
import lombok.Setter;
import org.apache.shardingsphere.test.it.sql.parser.internal.cases.parser.jaxb.segment.AbstractExpectedIdentifierSQLSegment;
import org.apache.shardingsphere.test.it.sql.parser.internal.cases.parser.jaxb.segment.impl.distsql.ExpectedAlgorithm;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;

/**
 * Expected encrypt column.
 */
@Getter
@Setter
public final class ExpectedEncryptColumn extends AbstractExpectedIdentifierSQLSegment {
    
    @XmlAttribute(name = "plain-column")
    private String plainColumn;
    
    @XmlAttribute(name = "cipher-column")
    private String cipherColumn;
    
    @XmlAttribute(name = "assisted-query-column")
    private String assistedQueryColumn;
    
    @XmlElement
    private ExpectedAlgorithm encryptor;
    
    @XmlElement(name = "assisted-query-encryptor")
    private ExpectedAlgorithm assistedQueryEncryptor;
}
