/*
 * Decompiled with CFR 0.152.
 */
package ru.rzn.gmyasoedov.maven.plugin.reader;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ResolutionErrorHandler;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import ru.rzn.gmyasoedov.maven.plugin.reader.BuildContext;
import ru.rzn.gmyasoedov.maven.plugin.reader.DependencyCoordinate;
import ru.rzn.gmyasoedov.maven.plugin.reader.model.MavenMapResult;

public abstract class GAbstractMojo
extends AbstractMojo {
    public static final String GMAVEN_POM_JSON = ".gmaven.pom.json";
    public static final String GMAVEN_TREE_JSON = ".gmaven.tree.json";
    @Component
    private RepositorySystem repositorySystem;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Component
    private ResolutionErrorHandler resolutionErrorHandler;
    @Parameter(property="processingPluginGAIds", defaultValue="")
    protected Set<String> processingPluginGAIds;
    @Parameter(property="resultFilePath", defaultValue="")
    protected String resultFilePath;
    @Parameter(property="addDependenciesInfo", defaultValue="false")
    protected boolean addDependenciesInfo;
    @Parameter(property="allPluginsInfo", defaultValue="true")
    protected boolean allPluginsInfo;
    @Parameter(property="addRemoteRepositoryInfo", defaultValue="false")
    protected boolean addRemoteRepositoryInfo;
    @Parameter(property="fullResourceInfo", defaultValue="false")
    protected boolean fullResourceInfo;
    @Parameter(property="resultAsTree", defaultValue="false")
    protected boolean resultAsTree;
    @Parameter(property="jsonPrettyPrinting", defaultValue="false")
    protected boolean jsonPrettyPrinting;
    @Parameter(property="incremental", defaultValue="false")
    protected boolean incremental;
    protected final Map<String, Field> dependencyCoordinateFieldMap = this.getDependencyCoordinateFieldMap();
    protected List<ArtifactResolutionException> resolveArtifactErrors = new ArrayList<ArtifactResolutionException>();

    private Map<String, Field> getDependencyCoordinateFieldMap() {
        Field[] fields = DependencyCoordinate.class.getDeclaredFields();
        HashMap<String, Field> map = new HashMap<String, Field>();
        for (Field field : fields) {
            field.setAccessible(true);
            map.put(field.getName().toLowerCase(), field);
        }
        return map;
    }

    protected BuildContext getExecuteContext() {
        return new BuildContext(this.addDependenciesInfo, this.allPluginsInfo, this.addRemoteRepositoryInfo, this.fullResourceInfo, this.resultAsTree, this.getIncrementalState());
    }

    private MavenMapResult getIncrementalState() {
        if (!this.incremental) {
            return null;
        }
        if (this.filePathIsEmpty()) {
            return null;
        }
        Path path = Paths.get(this.resultFilePath, new String[0]);
        if (!path.toFile().exists()) {
            return null;
        }
        MavenMapResult previousResult = this.getPreviousResult(path);
        if (previousResult != null && previousResult.container != null) {
            return previousResult;
        }
        return null;
    }

    protected List<String> resolveArtifacts(List<DependencyCoordinate> dependencyCoordinates, MavenProject project, MavenSession session) throws MojoExecutionException {
        if (dependencyCoordinates == null || dependencyCoordinates.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            LinkedHashSet<String> elements = new LinkedHashSet<String>();
            for (DependencyCoordinate coord : dependencyCoordinates) {
                ArtifactHandler handler = this.artifactHandlerManager.getArtifactHandler(coord.getType());
                DefaultArtifact artifact = new DefaultArtifact(coord.getGroupId(), coord.getArtifactId(), VersionRange.createFromVersionSpec((String)coord.getVersion()), "runtime", coord.getType(), coord.getClassifier(), handler, false);
                ArtifactResolutionRequest request = new ArtifactResolutionRequest().setArtifact((Artifact)artifact).setResolveRoot(true).setResolveTransitively(true).setLocalRepository(session.getLocalRepository()).setRemoteRepositories(project.getRemoteArtifactRepositories());
                ArtifactResolutionResult resolutionResult = this.repositorySystem.resolve(request);
                this.resolutionErrorHandler.throwErrors(request, resolutionResult);
                for (Artifact resolved : resolutionResult.getArtifacts()) {
                    elements.add(resolved.getFile().getAbsolutePath());
                }
            }
            return new ArrayList<String>(elements);
        }
        catch (ArtifactResolutionException e) {
            File file = GAbstractMojo.tryGetLocalArtifactFromTarget(project);
            if (file != null) {
                return Collections.singletonList(file.getAbsolutePath());
            }
            this.resolveArtifactErrors.add(e);
            return Collections.emptyList();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Resolution dependencies failed: " + e.getLocalizedMessage(), e);
        }
    }

    protected void printResult(Object result, MavenSession session) {
        Path resultPath = this.getResultPath(session);
        this.printResult(result, resultPath);
    }

    private Path getResultPath(MavenSession session) {
        if (this.filePathIsEmpty()) {
            Path path = GAbstractMojo.getBuildDirectory(session.getTopLevelProject()).resolve(GMAVEN_POM_JSON);
            this.getLog().info((CharSequence)("result file path: " + path));
            return path;
        }
        Path resultPath = Paths.get(this.resultFilePath, new String[0]);
        if (resultPath.toFile().isDirectory()) {
            throw new RuntimeException("Parameter resultFilePath is directory! Must be a file.");
        }
        return resultPath;
    }

    private boolean filePathIsEmpty() {
        return this.resultFilePath == null || this.resultFilePath.isEmpty();
    }

    protected void printResult(Object result, Path resultPath) {
        Path buildDirectory = resultPath.getParent();
        try {
            if (!buildDirectory.toFile().exists()) {
                Files.createDirectory(buildDirectory, new FileAttribute[0]);
            }
            try (FileWriter writer = new FileWriter(resultPath.toFile());){
                Gson gson = this.getGson();
                gson.toJson(result, (Appendable)writer);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected MavenMapResult getPreviousResult(Path resultPath) {
        MavenMapResult mavenMapResult;
        FileReader reader = new FileReader(resultPath.toFile());
        try {
            mavenMapResult = (MavenMapResult)new Gson().fromJson((Reader)reader, MavenMapResult.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)"Incremental previous state not found!", (Throwable)e);
                return null;
            }
        }
        ((Reader)reader).close();
        return mavenMapResult;
    }

    private Gson getGson() {
        if (this.jsonPrettyPrinting) {
            return new GsonBuilder().setPrettyPrinting().create();
        }
        return new Gson();
    }

    private static Path getBuildDirectory(MavenProject mavenProject) {
        String buildDirectory = mavenProject.getBuild().getDirectory();
        if (buildDirectory == null) {
            return mavenProject.getBasedir().toPath();
        }
        Path path = Paths.get(buildDirectory, new String[0]);
        if (path.getFileName().toString().endsWith("target")) {
            return path;
        }
        return mavenProject.getBasedir().toPath();
    }

    private static File tryGetLocalArtifactFromTarget(MavenProject project) {
        try {
            File[] files = new File(project.getBuild().getDirectory()).listFiles();
            if (files == null) {
                return null;
            }
            ArrayList<File> results = new ArrayList<File>(2);
            for (File file : files) {
                if (file.isDirectory() || !file.getName().endsWith(".jar")) continue;
                results.add(file);
            }
            if (results.size() == 1) {
                return (File)results.get(0);
            }
            for (File result : results) {
                if (!result.getName().contains(project.getArtifactId())) continue;
                return result;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

