/*
 * Decompiled with CFR 0.152.
 */
package ru.rzn.gmyasoedov.maven.plugin.reader;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import ru.rzn.gmyasoedov.maven.plugin.reader.BuildContext;
import ru.rzn.gmyasoedov.maven.plugin.reader.DependencyCoordinate;
import ru.rzn.gmyasoedov.maven.plugin.reader.GAbstractMojo;
import ru.rzn.gmyasoedov.maven.plugin.reader.converter.ListResultConverter;
import ru.rzn.gmyasoedov.maven.plugin.reader.converter.MapResultConverter;
import ru.rzn.gmyasoedov.maven.plugin.reader.plugins.PluginProcessorManager;
import ru.rzn.gmyasoedov.maven.plugin.reader.util.MavenContextUtils;

@Mojo(name="resolve", defaultPhase=LifecyclePhase.NONE, aggregator=true, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class ResolveProjectModelMojo
extends GAbstractMojo {
    @Parameter(defaultValue="${session}")
    private MavenSession session;
    @Parameter(property="resolvedPluginGAIds", defaultValue="")
    protected Set<String> resolvedPluginGAIds;

    public void execute() throws MojoExecutionException {
        BuildContext context = this.getExecuteContext();
        if (!context.readOnly && !this.getResolvedPluginGAIds().isEmpty()) {
            this.getLog().info((CharSequence)("resolvedArtifactIds " + this.resolvedPluginGAIds));
        }
        if (context.previousResult != null) {
            this.printLogIncrementalUpdate();
        }
        this.resolveArtifactErrors = new ArrayList();
        Set<String> gaPluginSet = this.getGAPluginForBodyProcessing();
        this.getLog().info((CharSequence)("ResolveProjectMojo: " + gaPluginSet));
        if (this.session.getAllProjects() == null) {
            return;
        }
        for (MavenProject mavenProject : this.session.getAllProjects()) {
            this.resolvePluginBody(mavenProject, gaPluginSet, context);
        }
        for (ArtifactResolutionException error : this.resolveArtifactErrors) {
            this.getLog().debug((CharSequence)("Resolution of annotationProcessorPath dependencies failed: " + error.getLocalizedMessage()), (Throwable)error);
        }
        Object result = this.getResult(context);
        this.printResult(result, this.session);
    }

    private void printLogIncrementalUpdate() {
        List projects = this.session.getProjects();
        if (projects == null || projects.isEmpty()) {
            return;
        }
        int allSize = this.session.getAllProjects().size();
        this.getLog().info((CharSequence)String.format("Incremental update projects start: %s/%s", projects.size(), allSize));
        this.getLog().info((CharSequence)"");
    }

    public void resolvePluginBody(MavenProject project, Set<String> gaPlugins, BuildContext context) throws MojoExecutionException {
        Model mavenModel = project.getModel();
        if (gaPlugins.isEmpty() || mavenModel == null) {
            return;
        }
        Build build = mavenModel.getBuild();
        if (build != null) {
            List plugins = build.getPlugins();
            if (plugins == null) {
                return;
            }
            for (Plugin each : plugins) {
                this.processPlugin(each, gaPlugins, project, context);
            }
        }
    }

    private void processPlugin(Plugin each, Set<String> gaPlugins, MavenProject project, BuildContext context) throws MojoExecutionException {
        String pluginKey = each.getGroupId() + ":" + each.getArtifactId();
        if (!gaPlugins.contains(pluginKey)) {
            return;
        }
        PluginProcessorManager.process(project, each);
        Map<String, Object> pluginBody = this.convertPluginBody(project, each, context);
        if (!pluginBody.isEmpty()) {
            String key = "gPlugin:" + pluginKey;
            project.setContextValue(key, pluginBody);
        }
        this.resolvePluginDependencies(each, project, context);
    }

    private void resolvePluginDependencies(Plugin each, MavenProject project, BuildContext context) throws MojoExecutionException {
        if (context.readOnly) {
            return;
        }
        String pluginKey = each.getGroupId() + ":" + each.getArtifactId();
        if (this.getResolvedPluginGAIds().contains(pluginKey)) {
            this.resolve(each.getArtifactId(), each.getGroupId(), each.getVersion(), project);
            List dependencies = each.getDependencies();
            if (dependencies == null) {
                return;
            }
            for (Dependency dependency : dependencies) {
                this.resolve(dependency.getArtifactId(), dependency.getGroupId(), dependency.getVersion(), project);
            }
        }
    }

    private Map<String, Object> convertPluginBody(MavenProject project, Plugin plugin, BuildContext context) throws MojoExecutionException {
        List<String> resolvedPaths = this.resolveMavenCompilerAnnotationProcessor(project, plugin, context);
        if (!resolvedPaths.isEmpty()) {
            MavenContextUtils.addListStringValues(project, "GMaven:annotationProcPaths", resolvedPaths);
        }
        ArrayList<Map<String, Object>> executions = new ArrayList<Map<String, Object>>(plugin.getExecutions().size());
        for (PluginExecution each : plugin.getExecutions()) {
            executions.add(ResolveProjectModelMojo.convertExecution(each));
        }
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        result.put("executions", executions);
        result.put("configuration", ResolveProjectModelMojo.convertConfiguration(plugin.getConfiguration()));
        return result;
    }

    private static Map<String, Object> convertExecution(PluginExecution execution) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        result.put("id", execution.getId());
        result.put("phase", execution.getPhase());
        result.put("goals", execution.getGoals());
        result.put("configuration", ResolveProjectModelMojo.convertConfiguration(execution.getConfiguration()));
        return result;
    }

    private static String convertConfiguration(Object config) {
        if (config instanceof Xpp3Dom) {
            return config.toString();
        }
        return null;
    }

    private Set<String> getGAPluginForBodyProcessing() {
        return this.processingPluginGAIds == null ? Collections.emptySet() : this.processingPluginGAIds;
    }

    private List<String> resolveMavenCompilerAnnotationProcessor(MavenProject project, Plugin plugin, BuildContext context) throws MojoExecutionException {
        if (context.readOnly || plugin == null || plugin.getConfiguration() == null || !"org.apache.maven.plugins".equals(plugin.getGroupId()) || !"maven-compiler-plugin".equals(plugin.getArtifactId())) {
            return Collections.emptyList();
        }
        List<DependencyCoordinate> dependencies = this.getDependencyCoordinatesForAnnotationProccessor(plugin);
        this.getLog().debug((CharSequence)("Dependencies for resolve " + dependencies));
        List<String> paths = this.resolveArtifacts(dependencies, project, this.session);
        if (!paths.isEmpty()) {
            this.getLog().info((CharSequence)("annotation processor paths " + paths));
        }
        return paths;
    }

    private List<DependencyCoordinate> getDependencyCoordinatesForAnnotationProccessor(Plugin plugin) throws MojoExecutionException {
        ArrayList<DependencyCoordinate> dependencies = new ArrayList<DependencyCoordinate>();
        Xpp3Dom configuration = (Xpp3Dom)plugin.getConfiguration();
        for (Xpp3Dom dom : configuration.getChildren()) {
            if (!"annotationProcessorPaths".equalsIgnoreCase(dom.getName())) continue;
            this.getLog().debug((CharSequence)("annotationProcessorPaths=" + dom));
            for (Xpp3Dom child : dom.getChildren()) {
                DependencyCoordinate coordinate = this.getDependencyCoordinate(child);
                if (coordinate == null) continue;
                dependencies.add(coordinate);
            }
            return dependencies;
        }
        return dependencies;
    }

    private DependencyCoordinate getDependencyCoordinate(Xpp3Dom dom) throws MojoExecutionException {
        DependencyCoordinate coordinate = new DependencyCoordinate();
        for (Xpp3Dom child : dom.getChildren()) {
            Field field;
            String name = child.getName().toLowerCase();
            String value = child.getValue();
            if (value == null || (field = (Field)this.dependencyCoordinateFieldMap.get(name)) == null) continue;
            try {
                field.set(coordinate, value);
            }
            catch (IllegalAccessException e) {
                throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)e);
            }
        }
        return coordinate.getArtifactId() == null || coordinate.getGroupId() == null || coordinate.getVersion() == null ? null : coordinate;
    }

    private Object getResult(BuildContext context) {
        return context.resultAsTree ? MapResultConverter.convert(this.session, context) : ListResultConverter.convert(this.session, context);
    }

    protected Set<String> getResolvedPluginGAIds() {
        return this.resolvedPluginGAIds != null ? this.resolvedPluginGAIds : Collections.emptySet();
    }

    private void resolve(String artifactId, String groupId, String version, MavenProject project) throws MojoExecutionException {
        DependencyCoordinate coordinateDep = new DependencyCoordinate();
        coordinateDep.setArtifactId(artifactId);
        coordinateDep.setGroupId(groupId);
        coordinateDep.setVersion(version);
        this.getLog().info((CharSequence)("gmaven.resolvedArtifactId " + coordinateDep));
        this.resolveArtifacts(Collections.singletonList(coordinateDep), project, this.session);
    }
}

