/*
 * Decompiled with CFR 0.152.
 */
package ru.rzn.gmyasoedov.maven.plugin.reader.converter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.RepositoryUtils;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import ru.rzn.gmyasoedov.maven.plugin.reader.converter.MavenArtifactConverter;
import ru.rzn.gmyasoedov.maven.plugin.reader.model.MavenArtifact;
import ru.rzn.gmyasoedov.maven.plugin.reader.model.MavenArtifactNode;
import ru.rzn.gmyasoedov.maven.plugin.reader.model.MavenArtifactState;
import ru.rzn.gmyasoedov.maven.plugin.reader.model.tree.DependencyTreeNode;

public class DependencyTreeNodeConverter {
    public static List<DependencyTreeNode> convert(Collection<? extends DependencyNode> nodes, Map<org.apache.maven.artifact.Artifact, MavenArtifact> convertedArtifactMap) {
        if (nodes == null || nodes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DependencyTreeNode> result = new ArrayList<DependencyTreeNode>(nodes.size());
        for (DependencyNode dependencyNode : nodes) {
            MavenArtifact mavenArtifact;
            org.apache.maven.artifact.Artifact artifactNode = DependencyTreeNodeConverter.toArtifact(dependencyNode.getDependency());
            MavenArtifactState state = MavenArtifactState.ADDED;
            Object winner = dependencyNode.getData().get("conflict.winner");
            MavenArtifactNode winnerArtifact = null;
            if (winner instanceof DependencyNode) {
                DependencyNode winnerNode = (DependencyNode)winner;
                winnerArtifact = DependencyTreeNodeConverter.convertToNode(DependencyTreeNodeConverter.toArtifact(winnerNode.getDependency()));
                mavenArtifact = MavenArtifactConverter.convert(artifactNode);
                state = !Objects.equals(dependencyNode.getVersion().toString(), winnerNode.getVersion().toString()) ? MavenArtifactState.CONFLICT : MavenArtifactState.DUPLICATE;
            } else {
                mavenArtifact = DependencyTreeNodeConverter.getArtifact(artifactNode, convertedArtifactMap);
            }
            DependencyTreeNode newNode = new DependencyTreeNode();
            newNode.artifact = DependencyTreeNodeConverter.convertToNode(mavenArtifact);
            newNode.relatedArtifact = winnerArtifact;
            newNode.state = state;
            newNode.originalScope = dependencyNode.getDependency().getScope();
            newNode.dependencies = DependencyTreeNodeConverter.convert(dependencyNode.getChildren(), convertedArtifactMap);
            result.add(newNode);
        }
        return result;
    }

    private static org.apache.maven.artifact.Artifact toArtifact(Dependency dependency) {
        if (dependency == null) {
            return null;
        }
        org.apache.maven.artifact.Artifact result = RepositoryUtils.toArtifact((Artifact)dependency.getArtifact());
        if (result == null) {
            return null;
        }
        result.setScope(dependency.getScope());
        result.setOptional(dependency.isOptional());
        return result;
    }

    public static MavenArtifact getArtifact(org.apache.maven.artifact.Artifact artifact, Map<org.apache.maven.artifact.Artifact, MavenArtifact> convertedArtifactMap) {
        MavenArtifact result = convertedArtifactMap.get(artifact);
        if (result == null) {
            result = MavenArtifactConverter.convert(artifact);
            convertedArtifactMap.put(artifact, result);
        }
        return result;
    }

    public static MavenArtifactNode convertToNode(org.apache.maven.artifact.Artifact artifact) {
        MavenArtifactNode result = new MavenArtifactNode();
        result.setGroupId(artifact.getGroupId());
        result.setArtifactId(artifact.getArtifactId());
        result.setVersion(artifact.getBaseVersion() != null ? artifact.getBaseVersion() : artifact.getVersion());
        result.setType(artifact.getType());
        result.setClassifier(artifact.getClassifier());
        result.setScope(artifact.getScope());
        result.setOptional(artifact.isOptional());
        result.setFilePath(artifact.getFile() == null ? null : artifact.getFile().getAbsolutePath());
        result.setResolved(artifact.isResolved());
        return result;
    }

    private static MavenArtifactNode convertToNode(MavenArtifact artifact) {
        MavenArtifactNode result = new MavenArtifactNode();
        result.setGroupId(artifact.getGroupId());
        result.setArtifactId(artifact.getArtifactId());
        result.setVersion(artifact.getVersion());
        result.setType(artifact.getType());
        result.setClassifier(artifact.getClassifier());
        result.setScope(artifact.getScope());
        result.setOptional(artifact.isOptional());
        result.setFilePath(artifact.getFilePath());
        result.setResolved(artifact.isResolved());
        return result;
    }
}

