/*
 * Decompiled with CFR 0.152.
 */
package ru.rzn.gmyasoedov.maven.plugin.reader.converter;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import ru.rzn.gmyasoedov.maven.plugin.reader.BuildContext;
import ru.rzn.gmyasoedov.maven.plugin.reader.converter.MapResultIncrementalConverter;
import ru.rzn.gmyasoedov.maven.plugin.reader.converter.MavenProjectConverter;
import ru.rzn.gmyasoedov.maven.plugin.reader.converter.MavenSettingsConverter;
import ru.rzn.gmyasoedov.maven.plugin.reader.model.MavenMapResult;
import ru.rzn.gmyasoedov.maven.plugin.reader.model.MavenProject;
import ru.rzn.gmyasoedov.maven.plugin.reader.model.MavenProjectContainer;

public class MapResultConverter {
    public static MavenMapResult convert(MavenSession session, BuildContext context) {
        if (context.previousResult != null && context.previousResult.container != null) {
            return MapResultIncrementalConverter.convert(session, context);
        }
        MavenMapResult result = new MavenMapResult();
        result.settings = MavenSettingsConverter.convert(session);
        result.container = MapResultConverter.getProjectsContainer(session, context);
        return result;
    }

    private static MavenProjectContainer getProjectsContainer(MavenSession session, BuildContext context) {
        List projects = session.getAllProjects();
        if (projects == null || projects.isEmpty()) {
            return null;
        }
        MavenExecutionResult executionResult = session.getResult();
        if (executionResult == null || executionResult.getProject() == null) {
            return null;
        }
        org.apache.maven.project.MavenProject topLevelProject = executionResult.getProject();
        Map<File, org.apache.maven.project.MavenProject> projectByDirectoryMap = MapResultConverter.getMapForProjects(projects);
        for (org.apache.maven.project.MavenProject sortedProject : projects) {
            projectByDirectoryMap.put(sortedProject.getBasedir(), sortedProject);
        }
        MavenProjectContainer container = new MavenProjectContainer(MavenProjectConverter.convert(topLevelProject, session, context));
        MapResultConverter.fillContainer(container, projectByDirectoryMap, context, session);
        return container;
    }

    private static Map<File, org.apache.maven.project.MavenProject> getMapForProjects(List<org.apache.maven.project.MavenProject> projects) {
        if (projects.size() > 128) {
            return new TreeMap<File, org.apache.maven.project.MavenProject>();
        }
        return new HashMap<File, org.apache.maven.project.MavenProject>((int)((double)projects.size() * 1.5));
    }

    private static void fillContainer(MavenProjectContainer rootContainer, Map<File, org.apache.maven.project.MavenProject> projectByDirectoryMap, BuildContext context, MavenSession session) {
        MavenProject project = rootContainer.getProject();
        for (String module : project.getModulesDir()) {
            File moduleFile;
            org.apache.maven.project.MavenProject mavenProjectByModuleFile;
            if (module == null || module.isEmpty() || (mavenProjectByModuleFile = projectByDirectoryMap.get(moduleFile = new File(module))) == null) continue;
            MavenProjectContainer projectContainer = new MavenProjectContainer(MavenProjectConverter.convert(mavenProjectByModuleFile, session, context));
            rootContainer.getModules().add(projectContainer);
            MapResultConverter.fillContainer(projectContainer, projectByDirectoryMap, context, session);
        }
    }
}

