/*
 * Decompiled with CFR 0.152.
 */
package ru.rzn.gmyasoedov.maven.plugin.reader.converter;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Resource;
import ru.rzn.gmyasoedov.maven.plugin.reader.BuildContext;
import ru.rzn.gmyasoedov.maven.plugin.reader.converter.MavenArtifactConverter;
import ru.rzn.gmyasoedov.maven.plugin.reader.converter.MavenPluginConverter;
import ru.rzn.gmyasoedov.maven.plugin.reader.converter.RemoteRepositoryConverter;
import ru.rzn.gmyasoedov.maven.plugin.reader.model.MavenArtifact;
import ru.rzn.gmyasoedov.maven.plugin.reader.model.MavenPlugin;
import ru.rzn.gmyasoedov.maven.plugin.reader.model.MavenProject;
import ru.rzn.gmyasoedov.maven.plugin.reader.model.MavenResource;
import ru.rzn.gmyasoedov.maven.plugin.reader.util.ObjectUtils;

public class MavenProjectConverter {
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
    private static final int MAX_PROJECT_RECURSION_DEPTH = 10;

    public static MavenProject convert(org.apache.maven.project.MavenProject mavenProject, MavenSession session, BuildContext context) {
        List<MavenPlugin> plugins = MavenProjectConverter.getPlugins(mavenProject, context);
        ArrayList<MavenArtifact> artifacts = new ArrayList<MavenArtifact>(mavenProject.getArtifacts().size());
        for (Artifact artifact : mavenProject.getArtifacts()) {
            artifacts.add(MavenArtifactConverter.convert(artifact));
        }
        List<String> modulesDir = MavenProjectConverter.convertModules(mavenProject.getBasedir(), mavenProject.getModules());
        if (context.readOnly) {
            HashSet<MavenArtifact> mavenArtifacts = new HashSet<MavenArtifact>(artifacts);
            MavenProjectConverter.addReferencedProjects(mavenProject, mavenArtifacts, context.readArtifactCache, session, 0);
            artifacts = new ArrayList<MavenArtifact>(mavenArtifacts);
        }
        MavenProject result = new MavenProject();
        result.setGroupId(ObjectUtils.emptyStringIfNull(mavenProject.getGroupId()));
        result.setArtifactId(ObjectUtils.emptyStringIfNull(mavenProject.getArtifactId()));
        result.setVersion(ObjectUtils.emptyStringIfNull(mavenProject.getVersion()));
        result.setPackaging(ObjectUtils.defaultIfNull(mavenProject.getPackaging(), "jar"));
        result.setName(mavenProject.getName());
        result.setBasedir(mavenProject.getBasedir().getAbsolutePath());
        result.setFilePath(mavenProject.getFile().getAbsolutePath());
        result.setParentFilePath(mavenProject.getParentFile() != null ? mavenProject.getParentFile().getAbsolutePath() : null);
        result.setModulesDir(modulesDir);
        result.setPlugins(plugins);
        result.setSourceRoots(mavenProject.getCompileSourceRoots());
        result.setTestSourceRoots(mavenProject.getTestCompileSourceRoots());
        result.setResourceRoots(MavenProjectConverter.convertResource(mavenProject.getResources(), context));
        result.setTestResourceRoots(MavenProjectConverter.convertResource(mavenProject.getTestResources(), context));
        result.setBuildDirectory(mavenProject.getBuild().getDirectory());
        result.setOutputDirectory(mavenProject.getBuild().getOutputDirectory());
        result.setTestOutputDirectory(mavenProject.getBuild().getTestOutputDirectory());
        result.setResolvedArtifacts(artifacts);
        if (context.addDependenciesInfo) {
            result.setDependencyArtifacts(MavenProjectConverter.convertMavenArtifact(mavenProject.getDependencyArtifacts()));
        }
        result.setParentArtifact(mavenProject.getParent() != null ? MavenArtifactConverter.convert(mavenProject.getParent()) : null);
        result.setProperties(MavenProjectConverter.getProperties(mavenProject));
        if (context.addRemoteRepositoryInfo) {
            List repositories = mavenProject.getRemoteArtifactRepositories();
            result.setRemoteRepositories(RemoteRepositoryConverter.convert(repositories));
        }
        result.setExcludedPaths(MavenProjectConverter.getExcludedPath(mavenProject));
        result.setGeneratedPath(MavenProjectConverter.getGeneratedPath(mavenProject));
        result.setTestGeneratedPath(MavenProjectConverter.getGeneratedTestPath(mavenProject));
        result.setAnnotationProcessorPaths(MavenProjectConverter.getAnnotationProcessorPath(mavenProject));
        return result;
    }

    private static List<MavenPlugin> getPlugins(org.apache.maven.project.MavenProject mavenProject, BuildContext context) {
        if (!context.allPluginsInfo) {
            return Collections.emptyList();
        }
        ArrayList<MavenPlugin> plugins = new ArrayList<MavenPlugin>(mavenProject.getBuildPlugins().size());
        for (Plugin plugin : mavenProject.getBuildPlugins()) {
            plugins.add(MavenPluginConverter.convert(plugin, mavenProject));
        }
        return plugins;
    }

    private static Map<Object, Object> getProperties(org.apache.maven.project.MavenProject mavenProject) {
        Properties projectProperties = mavenProject.getProperties();
        if (projectProperties == null) {
            return Collections.emptyMap();
        }
        HashMap<Object, Object> result = new HashMap<Object, Object>(projectProperties.size());
        result.putAll(projectProperties);
        return result;
    }

    private static List<String> convertModules(File basedir, List<String> modules) {
        if (modules == null || modules.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(modules.size());
        for (String module : modules) {
            result.add(MavenProjectConverter.getModuleFile(basedir, module).getAbsolutePath());
        }
        return result;
    }

    private static List<MavenResource> convertResource(List<Resource> resources, BuildContext context) {
        if (resources == null || resources.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MavenResource> result = new ArrayList<MavenResource>(resources.size());
        for (Resource item : resources) {
            MavenResource resource = new MavenResource();
            resource.setDirectory(item.getDirectory());
            if (context.fullResourceInfo) {
                resource.setExcludes(item.getExcludes());
                resource.setIncludes(item.getIncludes());
                resource.setFiltering(item.getFiltering());
                resource.setMergeId(item.getMergeId());
                resource.setTargetPath(item.getTargetPath());
            }
            result.add(resource);
        }
        return result;
    }

    private static List<MavenArtifact> convertMavenArtifact(Set<Artifact> artifacts) {
        if (artifacts == null || artifacts.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MavenArtifact> result = new ArrayList<MavenArtifact>(artifacts.size());
        for (Artifact item : artifacts) {
            result.add(MavenArtifactConverter.convert(item));
        }
        return result;
    }

    private static File getModuleFile(File parentProjectFile, String relativePath) {
        File moduleFile = new File(parentProjectFile, relativePath = relativePath.replace('\\', File.separatorChar).replace('/', File.separatorChar));
        if (moduleFile.isFile()) {
            moduleFile = moduleFile.getParentFile();
        }
        if (OS_NAME.contains("windows")) {
            try {
                moduleFile = moduleFile.getCanonicalFile();
            }
            catch (IOException e) {
                moduleFile = moduleFile.getAbsoluteFile();
            }
        } else {
            moduleFile = new File(moduleFile.toURI().normalize());
        }
        return moduleFile;
    }

    private static List<String> getExcludedPath(org.apache.maven.project.MavenProject project) {
        Object contextValue = project.getContextValue("GMaven:excludedPaths");
        if (contextValue instanceof List) {
            return (List)contextValue;
        }
        return Collections.emptyList();
    }

    private static List<String> getAnnotationProcessorPath(org.apache.maven.project.MavenProject project) {
        Object contextValue = project.getContextValue("GMaven:annotationProcPaths");
        if (contextValue instanceof List) {
            return (List)contextValue;
        }
        return Collections.emptyList();
    }

    private static String getGeneratedPath(org.apache.maven.project.MavenProject project) {
        Object contextValue = project.getContextValue("GMaven:generatedPath");
        if (contextValue instanceof String && !((String)contextValue).isEmpty()) {
            return (String)contextValue;
        }
        return Paths.get(project.getBuild().getDirectory(), "generated-sources", "annotations").toString();
    }

    private static String getGeneratedTestPath(org.apache.maven.project.MavenProject project) {
        Object contextValue = project.getContextValue("GMaven:generatedTestPath");
        if (contextValue instanceof String && !((String)contextValue).isEmpty()) {
            return (String)contextValue;
        }
        return Paths.get(project.getBuild().getDirectory(), "generated-test-sources", "test-annotations").toString();
    }

    private static void addReferencedProjects(org.apache.maven.project.MavenProject mavenProject, Set<MavenArtifact> artifacts, Map<String, MavenArtifact> artifactMap, MavenSession session, int depth) {
        if (depth > MavenProjectConverter.getMaxProjectRecursionDepth(session)) {
            return;
        }
        Map references = mavenProject.getProjectReferences();
        if (references != null) {
            for (org.apache.maven.project.MavenProject each : references.values()) {
                MavenArtifact mavenArtifact = MavenProjectConverter.getMavenArtifact(each, artifactMap);
                artifacts.add(mavenArtifact);
                MavenProjectConverter.addReferencedProjects(each, artifacts, artifactMap, session, depth + 1);
            }
        }
    }

    private static int getMaxProjectRecursionDepth(MavenSession session) {
        if (session.getAllProjects().size() > 50) {
            return 4;
        }
        return 10;
    }

    private static MavenArtifact getMavenArtifact(org.apache.maven.project.MavenProject each, Map<String, MavenArtifact> artifactMap) {
        MavenArtifact artifact = artifactMap.get(each.getArtifactId());
        if (artifact != null) {
            return artifact;
        }
        MavenArtifact mavenArtifact = MavenArtifactConverter.convert(each);
        artifactMap.put(each.getArtifactId(), mavenArtifact);
        return mavenArtifact;
    }
}

