/*
 * Decompiled with CFR 0.152.
 */
package ru.rzn.gmyasoedov.maven.plugin.reader.plugins;

import java.util.HashMap;
import java.util.Map;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import ru.rzn.gmyasoedov.maven.plugin.reader.plugins.ApacheMavenCompilerPluginProcessor;
import ru.rzn.gmyasoedov.maven.plugin.reader.plugins.BuildHelperMavenPluginProcessor;
import ru.rzn.gmyasoedov.maven.plugin.reader.plugins.CodehausAspectjMavenPlugin;
import ru.rzn.gmyasoedov.maven.plugin.reader.plugins.DevAspectjMavenPlugin;
import ru.rzn.gmyasoedov.maven.plugin.reader.plugins.GroovyMavenPlugin;
import ru.rzn.gmyasoedov.maven.plugin.reader.plugins.GroovyMavenPlusPlugin;
import ru.rzn.gmyasoedov.maven.plugin.reader.plugins.KotlinMavenPluginProcessor;
import ru.rzn.gmyasoedov.maven.plugin.reader.plugins.PluginProcessor;

public class PluginProcessorManager {
    private static final Map<String, PluginProcessor> processors = new HashMap<String, PluginProcessor>();

    private static void addProcessor(PluginProcessor processor) {
        processors.put(processor.groupId() + processor.artifactId(), processor);
    }

    public static void process(MavenProject project, Plugin plugin) {
        PluginProcessor processor = processors.get(plugin.getGroupId() + plugin.getArtifactId());
        if (processor != null) {
            processor.process(project, plugin);
        }
    }

    static {
        PluginProcessorManager.addProcessor(new ApacheMavenCompilerPluginProcessor());
        PluginProcessorManager.addProcessor(new BuildHelperMavenPluginProcessor());
        PluginProcessorManager.addProcessor(new CodehausAspectjMavenPlugin());
        PluginProcessorManager.addProcessor(new DevAspectjMavenPlugin());
        PluginProcessorManager.addProcessor(new GroovyMavenPlusPlugin());
        PluginProcessorManager.addProcessor(new GroovyMavenPlugin());
        PluginProcessorManager.addProcessor(new KotlinMavenPluginProcessor());
    }
}

