/*
 * Decompiled with CFR 0.152.
 */
package ru.rzn.gmyasoedov.maven.plugin.reader.plugins;

import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import ru.rzn.gmyasoedov.maven.plugin.reader.util.MavenContextUtils;
import ru.rzn.gmyasoedov.maven.plugin.reader.util.MavenJDOMUtil;
import ru.rzn.gmyasoedov.maven.plugin.reader.util.PluginUtils;

public abstract class AbstractGroovyPluginProcessor {
    public static void process(MavenProject project, Plugin plugin) {
        Object mainConfiguration = null;
        Object testConfiguration = null;
        Object stubConfiguration = null;
        Object testStubConfiguration = null;
        List executions = plugin.getExecutions();
        for (PluginExecution execution : executions) {
            List goals = execution.getGoals();
            if (goals == null) continue;
            if (goals.contains("compile")) {
                mainConfiguration = execution.getConfiguration();
            }
            if (goals.contains("testCompile") || goals.contains("compileTests")) {
                testConfiguration = execution.getConfiguration();
            }
            if (goals.contains("generateStubs")) {
                stubConfiguration = execution.getConfiguration();
            }
            if (!goals.contains("generateTestStubs")) continue;
            testStubConfiguration = execution.getConfiguration();
        }
        AbstractGroovyPluginProcessor.addSourcePaths(mainConfiguration, project, false);
        AbstractGroovyPluginProcessor.addSourcePaths(testConfiguration, project, true);
        MavenContextUtils.addListStringValue(project, "GMaven:excludedPaths", AbstractGroovyPluginProcessor.getExcludedPath(project, stubConfiguration));
        MavenContextUtils.addListStringValue(project, "GMaven:excludedPaths", AbstractGroovyPluginProcessor.getExcludedPath(project, testStubConfiguration));
    }

    private static String getExcludedPath(MavenProject mavenProject, Object config) {
        if (config == null) {
            return AbstractGroovyPluginProcessor.getDefaultExcludedDir(mavenProject);
        }
        String outputDirectory = PluginUtils.getValue(config, "outputDirectory");
        return outputDirectory != null ? PluginUtils.getAbsolutePath(outputDirectory, mavenProject) : AbstractGroovyPluginProcessor.getDefaultExcludedDir(mavenProject);
    }

    private static String getDefaultExcludedDir(MavenProject mavenProject) {
        return Paths.get(mavenProject.getBuild().getDirectory(), "generated-sources", "groovy-stubs").toString();
    }

    private static void addSourcePaths(Object config, MavenProject mavenProject, Boolean isTest) {
        List<String> paths;
        Xpp3Dom currentTag;
        Xpp3Dom xpp3Dom = currentTag = config instanceof Xpp3Dom ? (Xpp3Dom)config : null;
        if (currentTag == null) {
            paths = AbstractGroovyPluginProcessor.getDefaultPath(mavenProject, isTest);
        } else {
            paths = MavenJDOMUtil.findChildrenValuesByPath(currentTag, "sources", "fileset.directory");
            if (paths.isEmpty()) {
                paths = MavenJDOMUtil.findChildrenValuesByPath(currentTag, isTest != false ? "testSources" : "sources", isTest != false ? "testSource.directory" : "source.directory");
            }
            if (paths.isEmpty()) {
                paths = AbstractGroovyPluginProcessor.getDefaultPath(mavenProject, isTest);
            }
        }
        for (String path : paths) {
            if (isTest.booleanValue()) {
                mavenProject.addTestCompileSourceRoot(path);
                continue;
            }
            mavenProject.addCompileSourceRoot(path);
        }
    }

    private static List<String> getDefaultPath(MavenProject mavenProject, Boolean isTest) {
        String sourceFolderName = isTest != false ? "test" : "main";
        return Collections.singletonList(Paths.get(mavenProject.getBasedir().getAbsolutePath(), "src", sourceFolderName, "groovy").toString());
    }
}

