/*
 * Decompiled with CFR 0.152.
 */
package ru.rzn.gmyasoedov.maven.plugin.reader.plugins;

import java.util.List;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import ru.rzn.gmyasoedov.maven.plugin.reader.plugins.PluginProcessor;
import ru.rzn.gmyasoedov.maven.plugin.reader.util.PluginUtils;

public class BuildHelperMavenPluginProcessor
implements PluginProcessor {
    @Override
    public String groupId() {
        return "org.codehaus.mojo";
    }

    @Override
    public String artifactId() {
        return "build-helper-maven-plugin";
    }

    @Override
    public void process(MavenProject project, Plugin plugin) {
        List executions = plugin.getExecutions();
        for (PluginExecution execution : executions) {
            Resource resource;
            String absolutePath;
            List<String> pathList;
            List goals = execution.getGoals();
            if (goals == null) continue;
            if (goals.contains("add-source")) {
                pathList = PluginUtils.getPathList(execution.getConfiguration(), "sources");
                for (String path : pathList) {
                    project.addCompileSourceRoot(path);
                }
            }
            if (goals.contains("add-test-source")) {
                pathList = PluginUtils.getPathList(execution.getConfiguration(), "sources");
                for (String path : pathList) {
                    project.addTestCompileSourceRoot(path);
                }
            }
            if (goals.contains("add-resource")) {
                pathList = PluginUtils.getPathList(execution.getConfiguration(), "resources");
                for (String path : pathList) {
                    absolutePath = PluginUtils.getAbsolutePath(path, project);
                    if (absolutePath == null) continue;
                    resource = new Resource();
                    resource.setDirectory(absolutePath);
                    project.addResource(resource);
                }
            }
            if (!goals.contains("add-test-resource")) continue;
            pathList = PluginUtils.getPathList(execution.getConfiguration(), "resources");
            for (String path : pathList) {
                absolutePath = PluginUtils.getAbsolutePath(path, project);
                if (absolutePath == null) continue;
                resource = new Resource();
                resource.setDirectory(absolutePath);
                project.addTestResource(resource);
            }
        }
    }
}

