/*
 * Decompiled with CFR 0.152.
 */
package ru.rzn.gmyasoedov.maven.plugin.reader.plugins;

import java.util.List;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;
import ru.rzn.gmyasoedov.maven.plugin.reader.plugins.PluginProcessor;
import ru.rzn.gmyasoedov.maven.plugin.reader.util.PluginUtils;

public class KotlinMavenPluginProcessor
implements PluginProcessor {
    @Override
    public String groupId() {
        return "org.jetbrains.kotlin";
    }

    @Override
    public String artifactId() {
        return "kotlin-maven-plugin";
    }

    @Override
    public void process(MavenProject project, Plugin plugin) {
        List executions = plugin.getExecutions();
        for (PluginExecution execution : executions) {
            List<String> pathList;
            List goals = execution.getGoals();
            if (goals == null) continue;
            if (goals.contains("compile")) {
                pathList = PluginUtils.getPathList(execution.getConfiguration(), "sourceDirs");
                for (String path : pathList) {
                    project.addCompileSourceRoot(path);
                }
            }
            if (!goals.contains("test-compile")) continue;
            pathList = PluginUtils.getPathList(execution.getConfiguration(), "sourceDirs");
            for (String path : pathList) {
                project.addTestCompileSourceRoot(path);
            }
        }
    }
}

