/*
 * Decompiled with CFR 0.152.
 */
package io.github.guoshiqiufeng.dify.autoconfigure;

import io.github.guoshiqiufeng.dify.chat.DifyChat;
import io.github.guoshiqiufeng.dify.chat.client.DifyChatClient;
import io.github.guoshiqiufeng.dify.chat.impl.DifyChatClientImpl;
import io.github.guoshiqiufeng.dify.core.config.DifyProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestClient;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration
@ConditionalOnClass(value={DifyChatClient.class})
public class DifyChatAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DifyChatAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={DifyChatClient.class})
    public DifyChatClient difyChatClient(DifyProperties properties, ObjectProvider<RestClient.Builder> restClientBuilderProvider, ObjectProvider<WebClient.Builder> webClientBuilderProvider) {
        return new DifyChatClient(properties.getUrl(), properties.getClientConfig(), (RestClient.Builder)restClientBuilderProvider.getIfAvailable(RestClient::builder), (WebClient.Builder)webClientBuilderProvider.getIfAvailable(WebClient::builder));
    }

    @Bean
    @ConditionalOnMissingBean(value={DifyChat.class})
    public DifyChatClientImpl difyChatHandler(DifyChatClient difyChatClient) {
        return new DifyChatClientImpl(difyChatClient);
    }
}

