/*
 * Decompiled with CFR 0.152.
 */
package io.github.guoshiqiufeng.dify.autoconfigure;

import io.github.guoshiqiufeng.dify.core.config.DifyProperties;
import io.github.guoshiqiufeng.dify.dataset.DifyDataset;
import io.github.guoshiqiufeng.dify.dataset.client.DifyDatasetClient;
import io.github.guoshiqiufeng.dify.dataset.impl.DifyDatasetClientImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestClient;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration
@ConditionalOnClass(value={DifyDatasetClient.class})
public class DifyDatasetAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DifyDatasetAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={DifyDatasetClient.class})
    public DifyDatasetClient difyDatasetClient(DifyProperties properties, ObjectProvider<RestClient.Builder> restClientBuilderProvider, ObjectProvider<WebClient.Builder> webClientBuilderProvider) {
        String apikey = "Bearer " + properties.getDataset().getApiKey();
        return new DifyDatasetClient(properties.getUrl(), properties.getClientConfig(), ((RestClient.Builder)restClientBuilderProvider.getIfAvailable(RestClient::builder)).defaultHeader("Authorization", new String[]{apikey}), ((WebClient.Builder)webClientBuilderProvider.getIfAvailable(WebClient::builder)).defaultHeader("Authorization", new String[]{apikey}));
    }

    @Bean
    @ConditionalOnMissingBean(value={DifyDataset.class})
    public DifyDatasetClientImpl difyDataset(DifyDatasetClient difyDatasetClient) {
        return new DifyDatasetClientImpl(difyDatasetClient);
    }
}

