/*
 * Decompiled with CFR 0.152.
 */
package io.github.guoshiqiufeng.dify.autoconfigure;

import io.github.guoshiqiufeng.dify.autoconfigure.DifyServerRedisTokenAutoConfiguration;
import io.github.guoshiqiufeng.dify.core.config.DifyProperties;
import io.github.guoshiqiufeng.dify.server.DifyServer;
import io.github.guoshiqiufeng.dify.server.client.DifyServerClient;
import io.github.guoshiqiufeng.dify.server.client.DifyServerToken;
import io.github.guoshiqiufeng.dify.server.client.DifyServerTokenDefault;
import io.github.guoshiqiufeng.dify.server.impl.DifyServerClientImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestClient;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration
@AutoConfigureAfter(value={DifyServerRedisTokenAutoConfiguration.class})
@ConditionalOnClass(value={DifyServerClient.class})
public class DifyServerAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DifyServerAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={DifyServerToken.class})
    public DifyServerToken difyServerToken() {
        return new DifyServerTokenDefault();
    }

    @Bean
    @ConditionalOnMissingBean(value={DifyServerClient.class})
    public DifyServerClient difyServerClient(DifyProperties properties, DifyServerToken difyServerToken, ObjectProvider<RestClient.Builder> restClientBuilderProvider, ObjectProvider<WebClient.Builder> webClientBuilderProvider) {
        return new DifyServerClient(properties.getServer(), difyServerToken, properties.getUrl(), properties.getClientConfig(), (RestClient.Builder)restClientBuilderProvider.getIfAvailable(RestClient::builder), (WebClient.Builder)webClientBuilderProvider.getIfAvailable(WebClient::builder));
    }

    @Bean
    @ConditionalOnMissingBean(value={DifyServer.class})
    public DifyServerClientImpl difyServerHandler(DifyServerClient difyServerClient) {
        return new DifyServerClientImpl(difyServerClient);
    }
}

