/*
 * Decompiled with CFR 0.152.
 */
package io.github.guoyixing.heimdallr.common.enums;

import java.util.ArrayList;
import java.util.List;
import org.springframework.util.StringUtils;

public enum SecurityLevelEnum {
    NON_SECRET(0, "\u975e\u5bc6"),
    SECRET(1, "\u79d8\u5bc6"),
    CONFIDENTIAL(2, "\u673a\u5bc6"),
    TOP_SECRET(3, "\u7edd\u5bc6");

    private Integer key;
    private String value;

    private SecurityLevelEnum(Integer key, String value) {
        this.key = key;
        this.value = value;
    }

    public static List<SecurityLevelEnum> getOwnedPermissions(SecurityLevelEnum securityLevelEnum) {
        if (securityLevelEnum == null) {
            throw new IllegalArgumentException("SecurityLevelEnum is null");
        }
        ArrayList<SecurityLevelEnum> SecurityLevelEnums = new ArrayList<SecurityLevelEnum>();
        for (SecurityLevelEnum value : SecurityLevelEnum.values()) {
            if (value.getKey() > securityLevelEnum.key) continue;
            SecurityLevelEnums.add(value);
        }
        return SecurityLevelEnums;
    }

    public static List<SecurityLevelEnum> getDenyPermissions(SecurityLevelEnum securityLevelEnum) {
        if (securityLevelEnum == null) {
            throw new IllegalArgumentException("SecurityLevelEnum is null");
        }
        ArrayList<SecurityLevelEnum> SecurityLevelEnums = new ArrayList<SecurityLevelEnum>();
        for (SecurityLevelEnum value : SecurityLevelEnum.values()) {
            if (value.getKey() <= securityLevelEnum.key) continue;
            SecurityLevelEnums.add(value);
        }
        return SecurityLevelEnums;
    }

    public static SecurityLevelEnum getByKey(Integer documentLevel) {
        if (documentLevel == null) {
            return null;
        }
        for (SecurityLevelEnum value : SecurityLevelEnum.values()) {
            if (!value.getKey().equals(documentLevel)) continue;
            return value;
        }
        return null;
    }

    public static SecurityLevelEnum getByKey(String key) {
        if (!StringUtils.hasText((String)key)) {
            return null;
        }
        for (SecurityLevelEnum enumV : SecurityLevelEnum.values()) {
            if (!enumV.getKey().equals(Integer.valueOf(key))) continue;
            return enumV;
        }
        return null;
    }

    public static SecurityLevelEnum getByValue(String value) {
        if (!StringUtils.hasText((String)value)) {
            return null;
        }
        for (SecurityLevelEnum enumV : SecurityLevelEnum.values()) {
            if (!enumV.getValue().equals(value)) continue;
            return enumV;
        }
        return null;
    }

    public Integer getKey() {
        return this.key;
    }

    public void setKey(Integer key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

