/*
 * Decompiled with CFR 0.152.
 */
package io.github.guoyixing.heimdallr.strategy;

import io.github.guoyixing.heimdallr.support.SecurityLevelField;
import io.github.guoyixing.heimdallr.support.SecurityLevelManager;
import java.io.Serializable;
import java.util.ArrayList;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import org.springframework.data.jpa.domain.Specification;

public class SecurityLevelSpecification {
    public static <T, ID> Specification<T> getSpecification(Class<?> tClass, Iterable<ID> ids) {
        SecurityLevelManager securityLevelManager = SecurityLevelManager.getInstance();
        SecurityLevelField field = securityLevelManager.get(tClass);
        Object[] ownedPermissions = securityLevelManager.getOwnedPermissions();
        return (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            CriteriaBuilder.In idList = criteriaBuilder.in((Expression)root.get(field.getIdName()));
            for (Object id : ids) {
                idList.value(id);
            }
            predicates.add(criteriaBuilder.and(new Predicate[]{idList}));
            CriteriaBuilder.In<Object> securityLevels = SecurityLevelSpecification.getSecurityLevelIn(ownedPermissions, criteriaBuilder, (Path<Object>)root.get(field.getFieldName()));
            predicates.add(criteriaBuilder.and(new Predicate[]{securityLevels}));
            Predicate[] predicate = predicates.toArray(new Predicate[0]);
            return criteriaBuilder.and(predicate);
        };
    }

    public static <T> Specification<T> getSpecification(Class<?> tClass, Specification<T> spec) {
        SecurityLevelManager securityLevelManager = SecurityLevelManager.getInstance();
        SecurityLevelField field = securityLevelManager.get(tClass);
        Object[] ownedPermissions = securityLevelManager.getOwnedPermissions();
        Specification<T> securityLevelSpec = SecurityLevelSpecification.getSecurityLevelSpec(field, ownedPermissions);
        return spec.and(securityLevelSpec);
    }

    public static <T, ID> Specification<T> getSpecification(Class<?> tClass, ID id) {
        SecurityLevelManager securityLevelManager = SecurityLevelManager.getInstance();
        SecurityLevelField field = securityLevelManager.get(tClass);
        Object[] ownedPermissions = securityLevelManager.getOwnedPermissions();
        return (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(criteriaBuilder.equal((Expression)root.get(field.getIdName()), id));
            CriteriaBuilder.In<Object> securityLevels = SecurityLevelSpecification.getSecurityLevelIn(ownedPermissions, criteriaBuilder, (Path<Object>)root.get(field.getFieldName()));
            predicates.add(criteriaBuilder.and(new Predicate[]{securityLevels}));
            Predicate[] predicate = predicates.toArray(new Predicate[0]);
            return criteriaBuilder.and(predicate);
        };
    }

    public static <T> Specification<T> getSpecification(Class<?> tClass) {
        SecurityLevelManager securityLevelManager = SecurityLevelManager.getInstance();
        SecurityLevelField field = securityLevelManager.get(tClass);
        Object[] ownedPermissions = securityLevelManager.getOwnedPermissions();
        return SecurityLevelSpecification.getSecurityLevelSpec(field, ownedPermissions);
    }

    private static <T> Specification<T> getSecurityLevelSpec(SecurityLevelField field, Object[] ownedPermissions) {
        return (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            CriteriaBuilder.In<Object> securityLevels = SecurityLevelSpecification.getSecurityLevelIn(ownedPermissions, criteriaBuilder, (Path<Object>)root.get(field.getFieldName()));
            predicates.add(criteriaBuilder.and(new Predicate[]{securityLevels}));
            Predicate[] predicate = predicates.toArray(new Predicate[0]);
            return criteriaBuilder.and(predicate);
        };
    }

    private static CriteriaBuilder.In<Object> getSecurityLevelIn(Object[] ownedPermissions, CriteriaBuilder criteriaBuilder, Path<Object> objectPath) {
        CriteriaBuilder.In securityLevels = criteriaBuilder.in(objectPath);
        for (Object securityLevel : ownedPermissions) {
            securityLevels.value(securityLevel);
        }
        return securityLevels;
    }
}

