/*
 * Decompiled with CFR 0.152.
 */
package io.github.guoyixing.heimdallr.support;

import io.github.guoyixing.heimdallr.support.PermissionGetter;
import io.github.guoyixing.heimdallr.support.SecurityLevel;
import io.github.guoyixing.heimdallr.support.SecurityLevelField;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.Column;
import javax.persistence.Id;
import org.springframework.util.StringUtils;

public class SecurityLevelManager {
    private static volatile PermissionGetter permissionGetter;
    private final ThreadLocal<Object> currentSecurityLevel = new ThreadLocal();
    private final ThreadLocal<Boolean> securityLevelOnOff = new ThreadLocal();
    private static volatile SecurityLevelManager instance;
    private final Map<Class<?>, SecurityLevelField> securityLevelFieldCache = new ConcurrentHashMap();

    private SecurityLevelManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SecurityLevelManager getInstance() {
        if (instance != null) return instance;
        Class<SecurityLevelManager> clazz = SecurityLevelManager.class;
        synchronized (SecurityLevelManager.class) {
            if (instance != null) return instance;
            instance = new SecurityLevelManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Boolean securityLevelOnOff(Class<?> clazz) {
        return this.securityLevelOnOff() != false && instance.get(clazz) != null;
    }

    public void currentSecurityLevel(Object permissionGetter) {
        this.currentSecurityLevel.set(permissionGetter);
    }

    public void offSecurityLevel() {
        this.securityLevelOnOff.set(Boolean.FALSE);
    }

    public Boolean securityLevelOnOff() {
        if (this.securityLevelOnOff.get() == null) {
            return Boolean.TRUE;
        }
        return this.securityLevelOnOff.get();
    }

    public void setPermissionGetter(PermissionGetter permissionGetter) {
        SecurityLevelManager.permissionGetter = permissionGetter;
    }

    public Object[] getOwnedPermissions() {
        Object useSecurityLevel = this.currentSecurityLevel.get();
        if (useSecurityLevel == null) {
            useSecurityLevel = permissionGetter.getDefaultPermissions();
        }
        if (useSecurityLevel == null) {
            throw new NullPointerException("\u65e0\u6cd5\u83b7\u53d6\u5230\u5b89\u5168\u7b49\u7ea7\uff0c\u5c1d\u8bd5\u4f7f\u7528SecurityLevelManager\u7c7b\u8fdb\u884c\u8bbe\u7f6e");
        }
        return permissionGetter.getOwnedPermissions(useSecurityLevel);
    }

    public void put(Class<?> clazz) {
        SecurityLevelField securityLevelField = this.getSecurityLevelField(clazz);
        ArrayList<Field> fieldList = new ArrayList<Field>();
        while (clazz != null) {
            fieldList.addAll(new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields())));
            clazz = clazz.getSuperclass();
        }
        for (Field clazzField : fieldList) {
            Id idAnnotation;
            SecurityLevel securityLevelAnnotation = clazzField.getAnnotation(SecurityLevel.class);
            if (securityLevelAnnotation != null) {
                this.setSecurityLevel(securityLevelField, clazzField);
            }
            if ((idAnnotation = clazzField.getAnnotation(Id.class)) == null) continue;
            this.setId(securityLevelField, clazzField);
        }
        if (securityLevelField.getFieldClass() != null) {
            this.securityLevelFieldCache.put(securityLevelField.getSourceClass(), securityLevelField);
        }
    }

    public SecurityLevelField get(Class<?> clazz) {
        return this.securityLevelFieldCache.get(clazz);
    }

    private SecurityLevelField getSecurityLevelField(Class<?> clazz) {
        SecurityLevelField field = new SecurityLevelField();
        field.setSourceClass(clazz);
        return field;
    }

    private void setSecurityLevel(SecurityLevelField field, Field clazzField) {
        field.setFieldClass(clazzField.getType());
        field.setFieldName(clazzField.getName());
        Column column = clazzField.getAnnotation(Column.class);
        if (column != null && StringUtils.hasText((String)column.name())) {
            field.setDbFieldName(column.name());
        } else {
            field.setDbFieldName(clazzField.getName());
        }
    }

    private void setId(SecurityLevelField field, Field clazzField) {
        field.setIdName(clazzField.getName());
        Column column = clazzField.getAnnotation(Column.class);
        if (column != null && StringUtils.hasText((String)column.name())) {
            field.setDbIdName(column.name());
        } else {
            field.setDbIdName(clazzField.getName());
        }
    }
}

