/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.config;

import io.github.guoyixing.heimdallr.support.DefaultPermissionGetter;
import io.github.guoyixing.heimdallr.support.PermissionGetter;
import io.github.guoyixing.heimdallr.support.SecurityLevelManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.core.io.ResourceLoader;
import org.springframework.data.jpa.repository.config.JpaRepositoryConfigExtension;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfiguration;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.AbstractRepositoryMetadata;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class HeimdallrJpaRepositoryConfigExtension
extends JpaRepositoryConfigExtension {
    private static final Log logger = LogFactory.getLog(JpaRepositoryConfigExtension.class);
    private static final String PERMISSION_GETTER_ATTRIBUTE = "permissionGetter";

    public void postProcess(BeanDefinitionBuilder builder, RepositoryConfigurationSource source) {
        super.postProcess(builder, source);
        SecurityLevelManager.getInstance().setPermissionGetter(this.getPermissionGetter(source));
    }

    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        super.postProcess(builder, config);
        SecurityLevelManager.getInstance().setPermissionGetter(this.getPermissionGetter((RepositoryConfigurationSource)config));
    }

    public void postProcess(BeanDefinitionBuilder builder, XmlRepositoryConfigurationSource config) {
        super.postProcess(builder, config);
        SecurityLevelManager.getInstance().setPermissionGetter(this.getPermissionGetter((RepositoryConfigurationSource)config));
    }

    private PermissionGetter getPermissionGetter(RepositoryConfigurationSource source) {
        Optional attribute = source.getAttribute(PERMISSION_GETTER_ATTRIBUTE, Class.class);
        Class<DefaultPermissionGetter> clazz = attribute.orElse(DefaultPermissionGetter.class);
        try {
            return (PermissionGetter)clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("permissionGetter\u5fc5\u987b\u6709\u7a7a\u6784\u9020\u5668", e);
        }
    }

    public <T extends RepositoryConfigurationSource> Collection<RepositoryConfiguration<T>> getRepositoryConfigurations(T configSource, ResourceLoader loader, boolean strictMatchesOnly) {
        Assert.notNull(configSource, (String)"ConfigSource must not be null!");
        Assert.notNull((Object)loader, (String)"Loader must not be null!");
        HashSet<RepositoryConfiguration<T>> result = new HashSet<RepositoryConfiguration<T>>();
        for (BeanDefinition candidate : configSource.getCandidates(loader)) {
            RepositoryConfiguration configuration = this.getRepositoryConfiguration(candidate, configSource);
            Class<?> repositoryInterface = this.loadRepositoryInterface(configuration, this.getConfigurationInspectionClassLoader(loader));
            if (repositoryInterface == null) {
                result.add(configuration);
                continue;
            }
            RepositoryMetadata metadata = AbstractRepositoryMetadata.getMetadata(repositoryInterface);
            SecurityLevelManager.getInstance().put(metadata.getDomainType());
            boolean qualifiedForImplementation = !strictMatchesOnly || configSource.usesExplicitFilters() || this.isStrictRepositoryCandidate(metadata);
            if (!qualifiedForImplementation || !this.useRepositoryConfiguration(metadata)) continue;
            result.add(configuration);
        }
        return result;
    }

    @Nullable
    private Class<?> loadRepositoryInterface(RepositoryConfiguration<?> configuration, @Nullable ClassLoader classLoader) {
        String repositoryInterface = configuration.getRepositoryInterface();
        try {
            return ClassUtils.forName((String)repositoryInterface, (ClassLoader)classLoader);
        }
        catch (ClassNotFoundException | LinkageError var5) {
            logger.warn((Object)String.format("%s - Could not load type %s using class loader %s.", this.getModuleName(), repositoryInterface, classLoader), var5);
            return null;
        }
    }
}

