/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.lang.reflect.Method;
import javax.persistence.EntityManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.jpa.repository.query.EscapeCharacter;
import org.springframework.data.jpa.repository.query.HeimdallrJpaQueryFactory;
import org.springframework.data.jpa.repository.query.HeimdallrPartTreeJpaQuery;
import org.springframework.data.jpa.repository.query.JpaQueryLookupStrategy;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.JpaQueryMethodFactory;
import org.springframework.data.jpa.repository.query.NamedQuery;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class HeimdallrJpaQueryLookupStrategy {
    private static final Log LOG = LogFactory.getLog(JpaQueryLookupStrategy.class);

    private HeimdallrJpaQueryLookupStrategy() {
    }

    public static QueryLookupStrategy create(EntityManager em, JpaQueryMethodFactory queryMethodFactory, @Nullable QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider, EscapeCharacter escape) {
        Assert.notNull((Object)em, (String)"EntityManager must not be null!");
        Assert.notNull((Object)evaluationContextProvider, (String)"EvaluationContextProvider must not be null!");
        switch (key != null ? key : QueryLookupStrategy.Key.CREATE_IF_NOT_FOUND) {
            case CREATE: {
                return new CreateQueryLookupStrategy(em, queryMethodFactory, escape);
            }
            case USE_DECLARED_QUERY: {
                return new DeclaredQueryLookupStrategy(em, queryMethodFactory, evaluationContextProvider);
            }
            case CREATE_IF_NOT_FOUND: {
                return new CreateIfNotFoundQueryLookupStrategy(em, queryMethodFactory, new CreateQueryLookupStrategy(em, queryMethodFactory, escape), new DeclaredQueryLookupStrategy(em, queryMethodFactory, evaluationContextProvider));
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported query lookup strategy %s!", key));
    }

    private static class CreateIfNotFoundQueryLookupStrategy
    extends AbstractQueryLookupStrategy {
        private final DeclaredQueryLookupStrategy lookupStrategy;
        private final CreateQueryLookupStrategy createStrategy;

        public CreateIfNotFoundQueryLookupStrategy(EntityManager em, JpaQueryMethodFactory queryMethodFactory, CreateQueryLookupStrategy createStrategy, DeclaredQueryLookupStrategy lookupStrategy) {
            super(em, queryMethodFactory);
            Assert.notNull((Object)createStrategy, (String)"CreateQueryLookupStrategy must not be null!");
            Assert.notNull((Object)lookupStrategy, (String)"DeclaredQueryLookupStrategy must not be null!");
            this.createStrategy = createStrategy;
            this.lookupStrategy = lookupStrategy;
        }

        @Override
        protected RepositoryQuery resolveQuery(JpaQueryMethod method, EntityManager em, NamedQueries namedQueries) {
            try {
                return this.lookupStrategy.resolveQuery(method, em, namedQueries);
            }
            catch (IllegalStateException e) {
                return this.createStrategy.resolveQuery(method, em, namedQueries);
            }
        }
    }

    private static class DeclaredQueryLookupStrategy
    extends AbstractQueryLookupStrategy {
        private final QueryMethodEvaluationContextProvider evaluationContextProvider;

        public DeclaredQueryLookupStrategy(EntityManager em, JpaQueryMethodFactory queryMethodFactory, QueryMethodEvaluationContextProvider evaluationContextProvider) {
            super(em, queryMethodFactory);
            this.evaluationContextProvider = evaluationContextProvider;
        }

        @Override
        protected RepositoryQuery resolveQuery(JpaQueryMethod method, EntityManager em, NamedQueries namedQueries) {
            if (method.isProcedureQuery()) {
                return HeimdallrJpaQueryFactory.INSTANCE.fromProcedureAnnotation(method, em);
            }
            if (StringUtils.hasText((String)method.getAnnotatedQuery())) {
                if (method.hasAnnotatedQueryName()) {
                    LOG.warn((Object)String.format("Query method %s is annotated with both, a query and a query name. Using the declared query.", method));
                }
                return HeimdallrJpaQueryFactory.INSTANCE.fromMethodWithQueryString(method, em, method.getRequiredAnnotatedQuery(), this.getCountQuery(method, namedQueries, em), this.evaluationContextProvider);
            }
            String name = method.getNamedQueryName();
            if (namedQueries.hasQuery(name)) {
                return HeimdallrJpaQueryFactory.INSTANCE.fromMethodWithQueryString(method, em, namedQueries.getQuery(name), this.getCountQuery(method, namedQueries, em), this.evaluationContextProvider);
            }
            RepositoryQuery query = NamedQuery.lookupFrom((JpaQueryMethod)method, (EntityManager)em);
            if (null != query) {
                return query;
            }
            throw new IllegalStateException(String.format("Did neither find a NamedQuery nor an annotated query for method %s!", method));
        }

        @Nullable
        private String getCountQuery(JpaQueryMethod method, NamedQueries namedQueries, EntityManager em) {
            if (StringUtils.hasText((String)method.getCountQuery())) {
                return method.getCountQuery();
            }
            String queryName = method.getNamedCountQueryName();
            if (!StringUtils.hasText((String)queryName)) {
                return method.getCountQuery();
            }
            if (namedQueries.hasQuery(queryName)) {
                return namedQueries.getQuery(queryName);
            }
            boolean namedQuery = NamedQuery.hasNamedQuery((EntityManager)em, (String)queryName);
            if (namedQuery) {
                return method.getQueryExtractor().extractQueryString(em.createNamedQuery(queryName));
            }
            return null;
        }
    }

    private static class CreateQueryLookupStrategy
    extends AbstractQueryLookupStrategy {
        private final EscapeCharacter escape;

        public CreateQueryLookupStrategy(EntityManager em, JpaQueryMethodFactory queryMethodFactory, EscapeCharacter escape) {
            super(em, queryMethodFactory);
            this.escape = escape;
        }

        @Override
        protected RepositoryQuery resolveQuery(JpaQueryMethod method, EntityManager em, NamedQueries namedQueries) {
            return new HeimdallrPartTreeJpaQuery(method, em, this.escape);
        }
    }

    private static abstract class AbstractQueryLookupStrategy
    implements QueryLookupStrategy {
        private final EntityManager em;
        private final JpaQueryMethodFactory queryMethodFactory;

        public AbstractQueryLookupStrategy(EntityManager em, JpaQueryMethodFactory queryMethodFactory) {
            Assert.notNull((Object)em, (String)"EntityManager must not be null!");
            Assert.notNull((Object)queryMethodFactory, (String)"JpaQueryMethodFactory must not be null!");
            this.em = em;
            this.queryMethodFactory = queryMethodFactory;
        }

        public final RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            return this.resolveQuery(this.queryMethodFactory.build(method, metadata, factory), this.em, namedQueries);
        }

        protected abstract RepositoryQuery resolveQuery(JpaQueryMethod var1, EntityManager var2, NamedQueries var3);
    }
}

