/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import io.github.guoyixing.heimdallr.support.SecurityLevelField;
import io.github.guoyixing.heimdallr.support.SecurityLevelManager;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.EscapeCharacter;
import org.springframework.data.jpa.repository.query.JpaCountQueryCreator;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpaParametersParameterAccessor;
import org.springframework.data.jpa.repository.query.JpaQueryCreator;
import org.springframework.data.jpa.repository.query.JpaQueryExecution;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.jpa.repository.query.ParameterBinderFactory;
import org.springframework.data.jpa.repository.query.ParameterMetadataProvider;
import org.springframework.data.jpa.repository.query.PartTreeJpaQuery;
import org.springframework.data.jpa.repository.query.QueryParameterSetter;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.data.util.Streamable;
import org.springframework.lang.Nullable;

public class HeimdallrPartTreeJpaQuery
extends PartTreeJpaQuery {
    private final PartTree tree;
    private final JpaParameters parameters;
    private final QueryPreparer query;
    private final QueryPreparer countQuery;
    private final EntityManager em;
    private final EscapeCharacter escape;
    private final Class<?> domainClass;

    HeimdallrPartTreeJpaQuery(JpaQueryMethod method, EntityManager em) {
        this(method, em, EscapeCharacter.DEFAULT);
    }

    HeimdallrPartTreeJpaQuery(JpaQueryMethod method, EntityManager em, EscapeCharacter escape) {
        super(method, em);
        this.em = em;
        this.escape = escape;
        this.domainClass = method.getEntityInformation().getJavaType();
        this.parameters = method.getParameters();
        boolean recreationRequired = this.parameters.hasDynamicProjection() || this.parameters.potentiallySortsDynamically();
        try {
            this.tree = new PartTree(method.getName(), this.domainClass);
            HeimdallrPartTreeJpaQuery.validate(this.tree, this.parameters, method.toString());
            this.countQuery = new CountQueryPreparer(recreationRequired);
            this.query = this.tree.isCountProjection() ? this.countQuery : new QueryPreparer(recreationRequired);
        }
        catch (Exception o_O) {
            throw new IllegalArgumentException(String.format("Failed to create query for method %s! %s", method, o_O.getMessage()), o_O);
        }
    }

    public Query doCreateQuery(JpaParametersParameterAccessor accessor) {
        return this.query.createQuery(accessor);
    }

    public TypedQuery<Long> doCreateCountQuery(JpaParametersParameterAccessor accessor) {
        return (TypedQuery)this.countQuery.createQuery(accessor);
    }

    protected JpaQueryExecution getExecution() {
        if (this.tree.isDelete()) {
            return new JpaQueryExecution.DeleteExecution(this.em);
        }
        if (this.tree.isExistsProjection()) {
            return new JpaQueryExecution.ExistsExecution();
        }
        return super.getExecution();
    }

    private static void validate(PartTree tree, JpaParameters parameters, String methodName) {
        int argCount = 0;
        Iterable parts = () -> tree.stream().flatMap(Streamable::stream).iterator();
        for (Part part : parts) {
            int numberOfArguments = part.getNumberOfArguments();
            for (int i = 0; i < numberOfArguments; ++i) {
                HeimdallrPartTreeJpaQuery.throwExceptionOnArgumentMismatch(methodName, part, parameters, argCount);
                ++argCount;
            }
        }
    }

    private static void throwExceptionOnArgumentMismatch(String methodName, Part part, JpaParameters parameters, int index) {
        Part.Type type = part.getType();
        String property = part.getProperty().toDotPath();
        if (!((JpaParameters)parameters.getBindableParameters()).hasParameterAt(index)) {
            throw new IllegalStateException(String.format("Method %s expects at least %d arguments but only found %d. This leaves an operator of type %s for property %s unbound.", methodName, index + 1, index, type.name(), property));
        }
        JpaParameters.JpaParameter parameter = (JpaParameters.JpaParameter)parameters.getBindableParameter(index);
        if (HeimdallrPartTreeJpaQuery.expectsCollection(type) && !HeimdallrPartTreeJpaQuery.parameterIsCollectionLike(parameter)) {
            throw new IllegalStateException(HeimdallrPartTreeJpaQuery.wrongParameterTypeMessage(methodName, property, type, "Collection", parameter));
        }
        if (!HeimdallrPartTreeJpaQuery.expectsCollection(type) && !HeimdallrPartTreeJpaQuery.parameterIsScalarLike(parameter)) {
            throw new IllegalStateException(HeimdallrPartTreeJpaQuery.wrongParameterTypeMessage(methodName, property, type, "scalar", parameter));
        }
    }

    private static String wrongParameterTypeMessage(String methodName, String property, Part.Type operatorType, String expectedArgumentType, JpaParameters.JpaParameter parameter) {
        return String.format("Operator %s on %s requires a %s argument, found %s in method %s.", operatorType.name(), property, expectedArgumentType, parameter.getType(), methodName);
    }

    private static boolean parameterIsCollectionLike(JpaParameters.JpaParameter parameter) {
        return Iterable.class.isAssignableFrom(parameter.getType()) || parameter.getType().isArray();
    }

    private static boolean parameterIsScalarLike(JpaParameters.JpaParameter parameter) {
        return !Iterable.class.isAssignableFrom(parameter.getType());
    }

    private static boolean expectsCollection(Part.Type type) {
        return type == Part.Type.IN || type == Part.Type.NOT_IN;
    }

    private class CountQueryPreparer
    extends QueryPreparer {
        CountQueryPreparer(boolean recreateQueries) {
            super(recreateQueries);
        }

        @Override
        protected JpaQueryCreator createCreator(@Nullable JpaParametersParameterAccessor accessor) {
            EntityManager entityManager = HeimdallrPartTreeJpaQuery.this.getEntityManager();
            CriteriaBuilder builder = entityManager.getCriteriaBuilder();
            ParameterMetadataProvider provider = accessor != null ? new ParameterMetadataProvider(builder, (ParametersParameterAccessor)accessor, HeimdallrPartTreeJpaQuery.this.escape) : new ParameterMetadataProvider(builder, (Parameters)HeimdallrPartTreeJpaQuery.this.parameters, HeimdallrPartTreeJpaQuery.this.escape);
            return new JpaCountQueryCreator(HeimdallrPartTreeJpaQuery.this.tree, HeimdallrPartTreeJpaQuery.this.getQueryMethod().getResultProcessor().getReturnedType(), builder, provider);
        }

        @Override
        protected Query invokeBinding(ParameterBinder binder, TypedQuery<?> query, JpaParametersParameterAccessor accessor, QueryParameterSetter.QueryMetadataCache metadataCache) {
            QueryParameterSetter.QueryMetadata metadata = metadataCache.getMetadata("countquery", query);
            return binder.bind(query, metadata, accessor);
        }
    }

    private class QueryPreparer {
        @Nullable
        private final CriteriaQuery<?> cachedCriteriaQuery;
        @Nullable
        private final ParameterBinder cachedParameterBinder;
        private final QueryParameterSetter.QueryMetadataCache metadataCache = new QueryParameterSetter.QueryMetadataCache();

        QueryPreparer(boolean recreateQueries) {
            JpaQueryCreator creator = this.createCreator(null);
            if (recreateQueries) {
                this.cachedCriteriaQuery = null;
                this.cachedParameterBinder = null;
            } else {
                this.cachedCriteriaQuery = (CriteriaQuery)creator.createQuery();
                this.cachedParameterBinder = this.getBinder(creator.getParameterExpressions());
            }
        }

        public Query createQuery(JpaParametersParameterAccessor accessor) {
            CriteriaQuery criteriaQuery = this.cachedCriteriaQuery;
            ParameterBinder parameterBinder = this.cachedParameterBinder;
            if (this.cachedCriteriaQuery == null || accessor.hasBindableNullValue()) {
                JpaQueryCreator creator = this.createCreator(accessor);
                criteriaQuery = (CriteriaQuery)creator.createQuery(this.getDynamicSort(accessor));
                List expressions = creator.getParameterExpressions();
                parameterBinder = this.getBinder(expressions);
            }
            if (parameterBinder == null) {
                throw new IllegalStateException("ParameterBinder is null!");
            }
            TypedQuery<?> query = this.createQuery(criteriaQuery);
            return this.restrictMaxResultsIfNecessary(this.invokeBinding(parameterBinder, query, accessor, this.metadataCache));
        }

        private Query restrictMaxResultsIfNecessary(Query query) {
            if (HeimdallrPartTreeJpaQuery.this.tree.isLimiting()) {
                if (query.getMaxResults() != Integer.MAX_VALUE && query.getMaxResults() > HeimdallrPartTreeJpaQuery.this.tree.getMaxResults() && query.getFirstResult() > 0) {
                    query.setFirstResult(query.getFirstResult() - (query.getMaxResults() - HeimdallrPartTreeJpaQuery.this.tree.getMaxResults()));
                }
                query.setMaxResults(HeimdallrPartTreeJpaQuery.this.tree.getMaxResults().intValue());
            }
            if (HeimdallrPartTreeJpaQuery.this.tree.isExistsProjection()) {
                query.setMaxResults(1);
            }
            return query;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TypedQuery<?> createQuery(CriteriaQuery<?> criteriaQuery) {
            SecurityLevelManager instance = SecurityLevelManager.getInstance();
            if (this.cachedCriteriaQuery != null) {
                CriteriaQuery<?> criteriaQuery2 = this.cachedCriteriaQuery;
                synchronized (criteriaQuery2) {
                    if (instance.securityLevelOnOff(HeimdallrPartTreeJpaQuery.this.domainClass).booleanValue()) {
                        return this.setSecurityLevel(criteriaQuery, instance);
                    }
                    return HeimdallrPartTreeJpaQuery.this.getEntityManager().createQuery(criteriaQuery);
                }
            }
            if (instance.securityLevelOnOff(HeimdallrPartTreeJpaQuery.this.domainClass).booleanValue()) {
                return this.setSecurityLevel(criteriaQuery, instance);
            }
            return HeimdallrPartTreeJpaQuery.this.getEntityManager().createQuery(criteriaQuery);
        }

        private TypedQuery<?> setSecurityLevel(CriteriaQuery<?> criteriaQuery, SecurityLevelManager instance) {
            SecurityLevelField field = instance.get(HeimdallrPartTreeJpaQuery.this.domainClass);
            Predicate restriction = criteriaQuery.getRestriction();
            ArrayList roots = new ArrayList(criteriaQuery.getRoots());
            CriteriaBuilder criteriaBuilder = HeimdallrPartTreeJpaQuery.this.em.getCriteriaBuilder();
            CriteriaBuilder.In securityLevels = criteriaBuilder.in((Expression)((Root)roots.get(0)).get(field.getFieldName()));
            for (Object securityLevel : instance.getOwnedPermissions()) {
                securityLevels.value(securityLevel);
            }
            criteriaQuery.where(new Predicate[]{restriction, securityLevels});
            TypedQuery query = HeimdallrPartTreeJpaQuery.this.getEntityManager().createQuery(criteriaQuery);
            return query;
        }

        protected JpaQueryCreator createCreator(@Nullable JpaParametersParameterAccessor accessor) {
            ReturnedType returnedType;
            ParameterMetadataProvider provider;
            EntityManager entityManager = HeimdallrPartTreeJpaQuery.this.getEntityManager();
            CriteriaBuilder builder = entityManager.getCriteriaBuilder();
            ResultProcessor processor = HeimdallrPartTreeJpaQuery.this.getQueryMethod().getResultProcessor();
            if (accessor != null) {
                provider = new ParameterMetadataProvider(builder, (ParametersParameterAccessor)accessor, HeimdallrPartTreeJpaQuery.this.escape);
                returnedType = processor.withDynamicProjection((ParameterAccessor)accessor).getReturnedType();
            } else {
                provider = new ParameterMetadataProvider(builder, (Parameters)HeimdallrPartTreeJpaQuery.this.parameters, HeimdallrPartTreeJpaQuery.this.escape);
                returnedType = processor.getReturnedType();
            }
            return new JpaQueryCreator(HeimdallrPartTreeJpaQuery.this.tree, returnedType, builder, provider);
        }

        protected Query invokeBinding(ParameterBinder binder, TypedQuery<?> query, JpaParametersParameterAccessor accessor, QueryParameterSetter.QueryMetadataCache metadataCache) {
            QueryParameterSetter.QueryMetadata metadata = metadataCache.getMetadata("query", query);
            return binder.bindAndPrepare(query, metadata, accessor);
        }

        private ParameterBinder getBinder(List<ParameterMetadataProvider.ParameterMetadata<?>> expressions) {
            ParameterBinder parameterBinder = ParameterBinderFactory.createCriteriaBinder((JpaParameters)HeimdallrPartTreeJpaQuery.this.parameters, expressions);
            return parameterBinder;
        }

        private Sort getDynamicSort(JpaParametersParameterAccessor accessor) {
            return HeimdallrPartTreeJpaQuery.this.parameters.potentiallySortsDynamically() ? accessor.getSort() : Sort.unsorted();
        }
    }
}

