/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import java.util.Optional;
import javax.persistence.EntityManager;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.jpa.provider.QueryExtractor;
import org.springframework.data.jpa.repository.query.DefaultJpaQueryMethodFactory;
import org.springframework.data.jpa.repository.query.EscapeCharacter;
import org.springframework.data.jpa.repository.query.HeimdallrJpaQueryLookupStrategy;
import org.springframework.data.jpa.repository.query.JpaQueryMethodFactory;
import org.springframework.data.jpa.repository.support.HeimdallrSimpleJpaRepository;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class HeimdallrJpaRepositoryFactory
extends JpaRepositoryFactory {
    private final EntityManager entityManager;
    private EscapeCharacter escapeCharacter = EscapeCharacter.DEFAULT;
    private JpaQueryMethodFactory queryMethodFactory;

    public HeimdallrJpaRepositoryFactory(EntityManager entityManager) {
        super(entityManager);
        this.entityManager = entityManager;
        this.queryMethodFactory = new DefaultJpaQueryMethodFactory((QueryExtractor)PersistenceProvider.fromEntityManager((EntityManager)entityManager));
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(@Nullable QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return Optional.of(HeimdallrJpaQueryLookupStrategy.create(this.entityManager, this.queryMethodFactory, key, evaluationContextProvider, this.escapeCharacter));
    }

    public void setEscapeCharacter(EscapeCharacter escapeCharacter) {
        this.escapeCharacter = escapeCharacter;
    }

    public void setQueryMethodFactory(JpaQueryMethodFactory queryMethodFactory) {
        Assert.notNull((Object)queryMethodFactory, (String)"QueryMethodFactory must not be null!");
        this.queryMethodFactory = queryMethodFactory;
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return HeimdallrSimpleJpaRepository.class;
    }
}

