/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import io.github.guoyixing.heimdallr.strategy.SecurityLevelSpecification;
import io.github.guoyixing.heimdallr.support.SecurityLevelManager;
import java.util.List;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.convert.QueryByExamplePredicateBuilder;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.query.EscapeCharacter;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Repository
@Transactional(readOnly=true)
public class HeimdallrSimpleJpaRepository<T, ID>
extends SimpleJpaRepository<T, ID> {
    private final Class<?> tClass;
    private EscapeCharacter escapeCharacter = EscapeCharacter.DEFAULT;

    public void setEscapeCharacter(EscapeCharacter escapeCharacter) {
        this.escapeCharacter = escapeCharacter;
    }

    public HeimdallrSimpleJpaRepository(JpaEntityInformation<T, ?> entityInformation, EntityManager entityManager) {
        super(entityInformation, entityManager);
        this.tClass = entityInformation.getJavaType();
    }

    public HeimdallrSimpleJpaRepository(Class<T> domainClass, EntityManager em) {
        super(domainClass, em);
        this.tClass = domainClass;
    }

    public Optional<T> findById(ID id) {
        if (SecurityLevelManager.getInstance().securityLevelOnOff().booleanValue()) {
            Specification specification = SecurityLevelSpecification.getSpecification(this.tClass, id);
            return super.findOne(specification);
        }
        return super.findById(id);
    }

    @Deprecated
    public T getOne(ID id) {
        if (SecurityLevelManager.getInstance().securityLevelOnOff().booleanValue()) {
            Specification specification = SecurityLevelSpecification.getSpecification(this.tClass, id);
            return super.findOne(specification).get();
        }
        return (T)super.getOne(id);
    }

    @Deprecated
    public T getById(ID id) {
        if (SecurityLevelManager.getInstance().securityLevelOnOff().booleanValue()) {
            Specification specification = SecurityLevelSpecification.getSpecification(this.tClass, id);
            return super.findOne(specification).get();
        }
        return (T)super.getById(id);
    }

    public List<T> findAll() {
        if (SecurityLevelManager.getInstance().securityLevelOnOff().booleanValue()) {
            Specification specification = SecurityLevelSpecification.getSpecification(this.tClass);
            return super.findAll(specification);
        }
        return super.findAll();
    }

    public List<T> findAllById(Iterable<ID> ids) {
        if (SecurityLevelManager.getInstance().securityLevelOnOff().booleanValue()) {
            Specification specification = SecurityLevelSpecification.getSpecification(this.tClass, ids);
            return super.findAll(specification);
        }
        return super.findAllById(ids);
    }

    public List<T> findAll(Sort sort) {
        if (SecurityLevelManager.getInstance().securityLevelOnOff().booleanValue()) {
            Specification specification = SecurityLevelSpecification.getSpecification(this.tClass);
            return super.findAll(specification, sort);
        }
        return super.findAll(sort);
    }

    public Page<T> findAll(Pageable pageable) {
        if (SecurityLevelManager.getInstance().securityLevelOnOff().booleanValue()) {
            Specification specification = SecurityLevelSpecification.getSpecification(this.tClass);
            return super.findAll(specification, pageable);
        }
        return super.findAll(pageable);
    }

    public Optional<T> findOne(@Nullable Specification<T> spec) {
        if (SecurityLevelManager.getInstance().securityLevelOnOff().booleanValue()) {
            Specification<T> specification = this.getSpecification(spec);
            return super.findOne(specification);
        }
        return super.findOne(spec);
    }

    public List<T> findAll(@Nullable Specification<T> spec) {
        if (SecurityLevelManager.getInstance().securityLevelOnOff().booleanValue()) {
            Specification<T> specification = this.getSpecification(spec);
            return super.findAll(specification);
        }
        return super.findAll(spec);
    }

    public Page<T> findAll(@Nullable Specification<T> spec, Pageable pageable) {
        if (SecurityLevelManager.getInstance().securityLevelOnOff().booleanValue()) {
            Specification<T> specification = this.getSpecification(spec);
            return super.findAll(specification, pageable);
        }
        return super.findAll(spec, pageable);
    }

    public List<T> findAll(@Nullable Specification<T> spec, Sort sort) {
        if (SecurityLevelManager.getInstance().securityLevelOnOff().booleanValue()) {
            Specification specification = SecurityLevelSpecification.getSpecification(this.tClass);
            return super.findAll(specification, sort);
        }
        return super.findAll(spec, sort);
    }

    public <S extends T> Optional<S> findOne(Example<S> example) {
        if (SecurityLevelManager.getInstance().securityLevelOnOff().booleanValue()) {
            Specification specification = SecurityLevelSpecification.getSpecification(this.tClass, new ExampleSpecification<S>(example, this.escapeCharacter));
            try {
                return Optional.of(this.getQuery(specification, example.getProbeType(), Sort.unsorted()).getSingleResult());
            }
            catch (NoResultException e) {
                return Optional.empty();
            }
        }
        return super.findOne(example);
    }

    public <S extends T> List<S> findAll(Example<S> example) {
        if (SecurityLevelManager.getInstance().securityLevelOnOff().booleanValue()) {
            Specification specification = SecurityLevelSpecification.getSpecification(this.tClass, new ExampleSpecification<S>(example, this.escapeCharacter));
            return this.getQuery(specification, example.getProbeType(), Sort.unsorted()).getResultList();
        }
        return super.findAll(example);
    }

    public <S extends T> List<S> findAll(Example<S> example, Sort sort) {
        if (SecurityLevelManager.getInstance().securityLevelOnOff().booleanValue()) {
            Specification specification = SecurityLevelSpecification.getSpecification(this.tClass, new ExampleSpecification<S>(example, this.escapeCharacter));
            return this.getQuery(specification, example.getProbeType(), sort).getResultList();
        }
        return super.findAll(example, sort);
    }

    public <S extends T> Page<S> findAll(Example<S> example, Pageable pageable) {
        if (SecurityLevelManager.getInstance().securityLevelOnOff().booleanValue()) {
            Specification spec = SecurityLevelSpecification.getSpecification(this.tClass, new ExampleSpecification<S>(example, this.escapeCharacter));
            Class probeType = example.getProbeType();
            TypedQuery query = this.getQuery(SecurityLevelSpecification.getSpecification(this.tClass, new ExampleSpecification<S>(example, this.escapeCharacter)), probeType, pageable);
            return pageable.isUnpaged() ? new PageImpl(query.getResultList()) : this.readPage(query, probeType, pageable, spec);
        }
        return super.findAll(example, pageable);
    }

    private Specification<T> getSpecification(@Nullable Specification<T> spec) {
        Specification specification = spec == null ? SecurityLevelSpecification.getSpecification(this.tClass) : SecurityLevelSpecification.getSpecification(this.tClass, spec);
        return specification;
    }

    static class ExampleSpecification<T>
    implements Specification<T> {
        private static final long serialVersionUID = 1L;
        private final Example<T> example;
        private final EscapeCharacter escapeCharacter;

        ExampleSpecification(Example<T> example, EscapeCharacter escapeCharacter) {
            Assert.notNull(example, (String)"Example must not be null!");
            Assert.notNull((Object)escapeCharacter, (String)"EscapeCharacter must not be null!");
            this.example = example;
            this.escapeCharacter = escapeCharacter;
        }

        public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
            return QueryByExamplePredicateBuilder.getPredicate(root, (CriteriaBuilder)cb, this.example, (EscapeCharacter)this.escapeCharacter);
        }
    }
}

