/*
 * Decompiled with CFR 0.152.
 */
package com.holiday.utils;

import com.holiday.constants.VacationConstant;
import com.holiday.constants.WorkDayConstant;
import com.holiday.enums.HolidayEnum;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;

public class HolidayUtil {
    public static boolean isHoliday(String yyyyMMdd) {
        if (StringUtils.isEmpty((CharSequence)yyyyMMdd)) {
            return false;
        }
        Map<String, HolidayEnum> vacationMap = VacationConstant.vacationMap;
        HolidayEnum holidayEnum = vacationMap.get(yyyyMMdd);
        return null != holidayEnum;
    }

    public static boolean isHoliday(Date date) {
        if (date == null) {
            return false;
        }
        String yyyyMMdd = new DateTime(date.getTime()).toString("yyyyMMdd");
        return HolidayUtil.isHoliday(yyyyMMdd);
    }

    public static boolean isHoliday(Long timestamp) {
        if (null == timestamp) {
            return false;
        }
        String yyyyMMdd = new DateTime((Object)timestamp).toString("yyyyMMdd");
        return HolidayUtil.isHoliday(yyyyMMdd);
    }

    public static boolean isExchangeWordDay(String yyyyMMdd) {
        if (StringUtils.isEmpty((CharSequence)yyyyMMdd)) {
            return false;
        }
        Map<String, HolidayEnum> workDayMap = WorkDayConstant.workDayMap;
        HolidayEnum holidayEnum = workDayMap.get(yyyyMMdd);
        return null != holidayEnum;
    }

    public static boolean isExchangeWordDay(Date date) {
        if (date == null) {
            return false;
        }
        String yyyyMMdd = new DateTime(date.getTime()).toString("yyyyMMdd");
        return HolidayUtil.isExchangeWordDay(yyyyMMdd);
    }

    public static boolean isExchangeWordDay(Long timestamp) {
        if (null == timestamp) {
            return false;
        }
        String yyyyMMdd = new DateTime((Object)timestamp).toString("yyyyMMdd");
        return HolidayUtil.isExchangeWordDay(yyyyMMdd);
    }

    public static String getHolidayEnName(String yyyyMMdd) {
        if (StringUtils.isEmpty((CharSequence)yyyyMMdd)) {
            return null;
        }
        Map<String, HolidayEnum> vacationMap = VacationConstant.vacationMap;
        HolidayEnum holidayEnum = vacationMap.get(yyyyMMdd);
        if (null == holidayEnum) {
            return null;
        }
        return holidayEnum.getHolidayEnName();
    }

    public static String getHolidayEnName(Date date) {
        if (date == null) {
            return null;
        }
        String yyyyMMdd = new DateTime(date.getTime()).toString("yyyyMMdd");
        return HolidayUtil.getHolidayEnName(yyyyMMdd);
    }

    public static String getHolidayEnName(Long timestamp) {
        if (null == timestamp) {
            return null;
        }
        String yyyyMMdd = new DateTime((Object)timestamp).toString("yyyyMMdd");
        return HolidayUtil.getHolidayEnName(yyyyMMdd);
    }

    public static String getHolidayCnName(String yyyyMMdd) {
        if (StringUtils.isEmpty((CharSequence)yyyyMMdd)) {
            return null;
        }
        Map<String, HolidayEnum> vacationMap = VacationConstant.vacationMap;
        HolidayEnum holidayEnum = vacationMap.get(yyyyMMdd);
        if (null == holidayEnum) {
            return null;
        }
        return holidayEnum.getHolidayCnName();
    }

    public static String getHolidayCnName(Date date) {
        if (date == null) {
            return null;
        }
        String yyyyMMdd = new DateTime(date.getTime()).toString("yyyyMMdd");
        return HolidayUtil.getHolidayCnName(yyyyMMdd);
    }

    public static String getHolidayCnName(Long timestamp) {
        if (null == timestamp) {
            return null;
        }
        String yyyyMMdd = new DateTime((Object)timestamp).toString("yyyyMMdd");
        return HolidayUtil.getHolidayCnName(yyyyMMdd);
    }
}

