/*
 * Decompiled with CFR 0.152.
 */
package skuber.api.client.impl;

import com.typesafe.config.Config;
import java.io.Serializable;
import javax.net.ssl.SSLContext;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.scaladsl.model.HttpMethod;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpRequest$;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.settings.ClientConnectionSettings;
import org.apache.pekko.http.scaladsl.settings.ConnectionPoolSettings;
import org.apache.pekko.http.scaladsl.settings.ConnectionPoolSettings$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import skuber.api.client.Context;
import skuber.api.client.LoggingConfig;
import skuber.api.client.impl.KubernetesClientImpl;
import skuber.api.security.TLS$;
import skuber.config.SkuberConfig;
import skuber.config.SkuberConfig$;

public final class KubernetesClientImpl$ {
    public static KubernetesClientImpl$ MODULE$;

    static {
        new KubernetesClientImpl$();
    }

    public KubernetesClientImpl apply(Context k8sContext, LoggingConfig logConfig, Option<Function0<BoxedUnit>> closeHook, Config appConfig, Option<ConnectionPoolSettings> connectionPoolSettings, ActorSystem actorSystem) {
        SkuberConfig skuberConfig = SkuberConfig$.MODULE$.load(appConfig);
        ExecutionContext dispatcher = (ExecutionContext)skuberConfig.getSkuberConfig("pekko.dispatcher", (Function1 & Serializable & scala.Serializable)configKey -> KubernetesClientImpl$.dispatcherFromConfig$1(configKey, appConfig, actorSystem), actorSystem.dispatcher());
        Duration watchIdleTimeout = skuberConfig.getDuration("watch.idle-timeout", (Duration)Duration$.MODULE$.Inf());
        Duration podLogIdleTimeout = skuberConfig.getDuration("pod-log.idle-timeout", (Duration)Duration$.MODULE$.Inf());
        Duration watchContinuouslyRequestTimeout = skuberConfig.getDuration("watch-continuously.request-timeout", (Duration)new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds());
        Duration watchContinuouslyIdleTimeout = skuberConfig.getDuration("watch-continuously.idle-timeout", (Duration)new package.DurationInt(package$.MODULE$.DurationInt(60)).seconds());
        Duration watchPoolIdleTimeout = skuberConfig.getDuration("watch-continuously.pool-idle-timeout", (Duration)new package.DurationInt(package$.MODULE$.DurationInt(60)).seconds());
        Predef$.MODULE$.require(watchContinuouslyIdleTimeout.$greater((Object)watchContinuouslyRequestTimeout));
        if (logConfig.logConfiguration()) {
            LoggingAdapter log = Logging$.MODULE$.getLogger(actorSystem, (Object)"skuber.api");
            log.info("Using following context for connecting to Kubernetes cluster: {}", (Object)k8sContext);
        }
        Option<SSLContext> sslContext = TLS$.MODULE$.establishSSLContext(k8sContext);
        String string = k8sContext.namespace().name();
        String string2 = "".equals(string) ? "default" : string;
        String theNamespaceName = string2;
        Function2 & Serializable & scala.Serializable requestMaker = (Function2 & Serializable & scala.Serializable)(uri, method) -> HttpRequest$.MODULE$.apply(method, uri, HttpRequest$.MODULE$.apply$default$3(), HttpRequest$.MODULE$.apply$default$4(), HttpRequest$.MODULE$.apply$default$5());
        ConnectionPoolSettings defaultClientSettings = (ConnectionPoolSettings)connectionPoolSettings.getOrElse((Function0 & Serializable & scala.Serializable)() -> (ConnectionPoolSettings)ConnectionPoolSettings$.MODULE$.apply(actorSystem));
        ClientConnectionSettings watchConnectionSettings = defaultClientSettings.connectionSettings().withIdleTimeout(watchIdleTimeout);
        ConnectionPoolSettings watchSettings = defaultClientSettings.withConnectionSettings(watchConnectionSettings);
        ClientConnectionSettings podLogConnectionSettings = defaultClientSettings.connectionSettings().withIdleTimeout(podLogIdleTimeout);
        ConnectionPoolSettings podLogSettings = defaultClientSettings.withConnectionSettings(podLogConnectionSettings);
        return new KubernetesClientImpl((Function2<Uri, HttpMethod, HttpRequest>)requestMaker, k8sContext.cluster().server(), k8sContext.authInfo(), theNamespaceName, watchContinuouslyRequestTimeout, watchContinuouslyIdleTimeout, watchPoolIdleTimeout, defaultClientSettings, watchSettings, podLogSettings, sslContext, logConfig, closeHook, actorSystem, dispatcher);
    }

    public Option<ConnectionPoolSettings> apply$default$5() {
        return None$.MODULE$;
    }

    private static final Option dispatcherFromConfig$1(String configKey, Config appConfig$1, ActorSystem actorSystem$1) {
        return appConfig$1.getString(configKey).isEmpty() ? None$.MODULE$ : new Some((Object)actorSystem$1.dispatchers().lookup(appConfig$1.getString(configKey)));
    }

    private KubernetesClientImpl$() {
        MODULE$ = this;
    }
}

