/*
 * Decompiled with CFR 0.152.
 */
package skuber.api.security;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Some;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class SecurityHelper$ {
    public static SecurityHelper$ MODULE$;

    static {
        new SecurityHelper$();
    }

    public List<X509Certificate> readCertificates(InputStream is) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(CertificateFactory.getInstance("X509").generateCertificates(is)).asScala()).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Certificate, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                X509Certificate x509Certificate;
                A1 A1 = x1;
                if (!(A1 instanceof X509Certificate)) {
                    throw new Exception("Not X509 cert?");
                }
                X509Certificate x509Certificate2 = x509Certificate = (X509Certificate)A1;
                return (B1)x509Certificate2;
            }

            public final boolean isDefinedAt(Certificate x1) {
                Certificate certificate = x1;
                boolean bl = certificate instanceof X509Certificate ? true : true;
                return bl;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toList();
    }

    private InputStream createInputStreamForPathOrData(Either<String, byte[]> target) {
        InputStream inputStream;
        Either<String, byte[]> either = target;
        if (either instanceof Right) {
            Right right = (Right)either;
            byte[] data = (byte[])right.value();
            inputStream = new ByteArrayInputStream(data);
        } else if (either instanceof Left) {
            Left left = (Left)either;
            String path = (String)left.value();
            Path filePath = Paths.get(path, new String[0]);
            inputStream = Files.newInputStream(filePath, new OpenOption[0]);
        } else {
            throw new MatchError(either);
        }
        return inputStream;
    }

    public List<X509Certificate> getCertificates(Either<String, byte[]> from) {
        InputStream is = this.createInputStreamForPathOrData(from);
        return this.readCertificates(is);
    }

    public KeyStore createTrustStore(List<X509Certificate> apiServerCerts) {
        KeyStore trustStore2 = KeyStore.getInstance("JKS");
        trustStore2.load(null);
        return (KeyStore)apiServerCerts.foldLeft((Object)trustStore2, (Function2 & Serializable & scala.Serializable)(trustStore, apiServerCert) -> {
            String alias = apiServerCert.getSubjectX500Principal().getName();
            trustStore.setCertificateEntry(alias, (Certificate)apiServerCert);
            return trustStore;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PrivateKey readPrivateKey(InputStream is) {
        BouncyCastleProvider provider = new BouncyCastleProvider();
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider((Provider)provider);
        Option option = Option$.MODULE$.apply(new PEMParser((Reader)new InputStreamReader(is)).readObject());
        if (option instanceof Some) {
            PrivateKey privateKey;
            Some some = (Some)option;
            Object obj = some.value();
            Object object = obj;
            if (object instanceof PEMKeyPair) {
                PEMKeyPair pEMKeyPair = (PEMKeyPair)object;
                privateKey = converter.getPrivateKey(pEMKeyPair.getPrivateKeyInfo());
                return privateKey;
            } else {
                if (!(object instanceof PrivateKeyInfo)) throw new MatchError(object);
                PrivateKeyInfo privateKeyInfo = (PrivateKeyInfo)object;
                privateKey = converter.getPrivateKey(privateKeyInfo);
            }
            return privateKey;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
        throw new IOException("could not read private key");
    }

    public PrivateKey getPrivateKey(Either<String, byte[]> from) {
        InputStream is = this.createInputStreamForPathOrData(from);
        return this.readPrivateKey(is);
    }

    public KeyStore createKeyStore(String user, List<X509Certificate> clientCertificates, PrivateKey clientPrivateKey, Option<String> password) {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        char[] keyStorePassword = ((String)password.orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)"changeit")).get()).toCharArray();
        keyStore.load(null, keyStorePassword);
        keyStore.setKeyEntry(user, clientPrivateKey, keyStorePassword, (Certificate[])clientCertificates.toArray(ClassTag$.MODULE$.apply(Certificate.class)));
        return keyStore;
    }

    public Option<String> createKeyStore$default$4() {
        return None$.MODULE$;
    }

    private SecurityHelper$() {
        MODULE$ = this;
    }
}

