/*
 * Decompiled with CFR 0.152.
 */
package io.github.haibiiin.json.repair;

import io.github.haibiiin.json.repair.Expecting;
import io.github.haibiiin.json.repair.ExtractStrategy;
import io.github.haibiiin.json.repair.JSONRepairConfig;
import io.github.haibiiin.json.repair.OverstepTryTimesException;
import io.github.haibiiin.json.repair.ParserListBuilder;
import io.github.haibiiin.json.repair.RepairFailureException;
import io.github.haibiiin.json.repair.RepairStrategy;
import io.github.haibiiin.json.repair.antlr.DefaultErrorStrategyWrapper;
import io.github.haibiiin.json.repair.antlr.SyntaxErrorListener;
import io.github.haibiiin.json.repair.antlr.autogen.JSONLexer;
import io.github.haibiiin.json.repair.antlr.autogen.JSONParser;
import io.github.haibiiin.json.repair.strategy.SimpleExtractStrategy;
import io.github.haibiiin.json.repair.strategy.SimpleRepairStrategy;
import java.util.List;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

public class JSONRepair {
    private final RepairStrategy repairStrategy;
    private final ExtractStrategy extractStrategy;
    private final JSONRepairConfig properties;

    public JSONRepair() {
        this.repairStrategy = new SimpleRepairStrategy();
        this.extractStrategy = new SimpleExtractStrategy();
        this.properties = new JSONRepairConfig();
    }

    public JSONRepair(RepairStrategy repairStrategy) {
        this.repairStrategy = repairStrategy;
        this.extractStrategy = new SimpleExtractStrategy();
        this.properties = new JSONRepairConfig();
    }

    public JSONRepair(JSONRepairConfig config) {
        this.repairStrategy = new SimpleRepairStrategy();
        this.extractStrategy = new SimpleExtractStrategy();
        this.properties = config;
    }

    public JSONRepair(RepairStrategy repairStrategy, JSONRepairConfig config) {
        this.repairStrategy = repairStrategy;
        this.extractStrategy = new SimpleExtractStrategy();
        this.properties = config;
    }

    public JSONRepair(RepairStrategy repairStrategy, ExtractStrategy extractStrategy, JSONRepairConfig properties) {
        this.repairStrategy = repairStrategy;
        this.extractStrategy = extractStrategy;
        this.properties = properties;
    }

    public String handle(String beRepairJSON) throws RepairFailureException {
        CodePointCharStream charStream = CharStreams.fromString((String)beRepairJSON);
        JSONLexer lexer = new JSONLexer((CharStream)charStream);
        JSONParser parser = new JSONParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        Expecting expecting = new Expecting();
        SyntaxErrorListener syntaxErrorListener = new SyntaxErrorListener(new DefaultErrorStrategyWrapper(), expecting);
        lexer.removeErrorListeners();
        parser.removeErrorListeners();
        lexer.addErrorListener(syntaxErrorListener);
        parser.addErrorListener(syntaxErrorListener);
        JSONParser.JsonContext ctx = parser.json();
        if (this.correct(expecting)) {
            return beRepairJSON;
        }
        int maxTryTimes = Math.max(expecting.sum(), this.properties.maxTryTimes());
        List<ParseTree> beRepairParseList = ParserListBuilder.build((ParseTree)ctx);
        if (this.properties.extractJSON()) {
            String repairJSON = this.extractStrategy.extract(beRepairJSON, beRepairParseList, expecting);
            return this.subHandle(repairJSON, maxTryTimes, 0);
        }
        String repairJSON = this.repairStrategy.repair(beRepairJSON, beRepairParseList, expecting);
        return this.subHandle(repairJSON, maxTryTimes, 0);
    }

    public String subHandle(String beRepairJSON, int maxTryTimes, int tryTimes) {
        if (tryTimes == maxTryTimes) {
            throw new OverstepTryTimesException();
        }
        CodePointCharStream charStream = CharStreams.fromString((String)beRepairJSON);
        JSONLexer lexer = new JSONLexer((CharStream)charStream);
        JSONParser parser = new JSONParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        Expecting expecting = new Expecting();
        SyntaxErrorListener syntaxErrorListener = new SyntaxErrorListener(new DefaultErrorStrategyWrapper(), expecting);
        lexer.removeErrorListeners();
        parser.removeErrorListeners();
        lexer.addErrorListener(syntaxErrorListener);
        parser.addErrorListener(syntaxErrorListener);
        JSONParser.JsonContext ctx = parser.json();
        if (this.correct(expecting)) {
            return beRepairJSON;
        }
        List<ParseTree> beRepairParseList = ParserListBuilder.build((ParseTree)ctx);
        String repairJSON = this.repairStrategy.repair(beRepairJSON, beRepairParseList, expecting);
        return this.subHandle(repairJSON, maxTryTimes, ++tryTimes);
    }

    private boolean correct(Expecting expecting) {
        return expecting.none();
    }
}

