/*
 * Decompiled with CFR 0.152.
 */
package io.github.haibiiin.json.repair.antlr;

import io.github.haibiiin.json.repair.Expecting;
import io.github.haibiiin.json.repair.antlr.DefaultErrorStrategyWrapper;
import io.github.haibiiin.json.repair.antlr.IntervalSetSimplifiedWrapper;
import io.github.haibiiin.json.repair.antlr.KeySymbol;
import io.github.haibiiin.json.repair.antlr.VocabularyWrapper;
import io.github.haibiiin.json.repair.antlr.autogen.JSONLexer;
import io.github.haibiiin.json.repair.antlr.autogen.JSONParser;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.NoViableAltException;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.misc.IntervalSet;

public class SyntaxErrorListener
implements ANTLRErrorListener {
    private DefaultErrorStrategyWrapper strategyWrapper;
    private Expecting expecting;

    public SyntaxErrorListener(DefaultErrorStrategyWrapper strategyWrapper, Expecting expecting) {
        this.strategyWrapper = strategyWrapper;
        this.expecting = expecting;
    }

    public void syntaxError(Recognizer<?, ?> recognizer, Object o, int i, int i1, String s, RecognitionException e) {
        if (recognizer instanceof JSONParser) {
            Token token = ((JSONParser)recognizer).getCurrentToken();
            String expectingKey = this.strategyWrapper.getTokenErrorDisplay(token);
            List<Object> expectingStrs = new ArrayList();
            if (e instanceof NoViableAltException) {
                if (KeySymbol.L_BRACKET.val().equalsIgnoreCase(expectingKey)) {
                    expectingStrs = KeySymbol.value();
                }
                if (KeySymbol.L_BRACE.val().equalsIgnoreCase(expectingKey)) {
                    expectingStrs = KeySymbol.obj();
                }
            } else {
                IntervalSet expectingSet = ((JSONParser)recognizer).getExpectedTokens();
                IntervalSetSimplifiedWrapper expectingWrapper = new IntervalSetSimplifiedWrapper(expectingSet);
                expectingStrs = expectingWrapper.toStringList(new VocabularyWrapper(recognizer.getVocabulary()));
            }
            this.expecting.add(i1, expectingKey, expectingStrs);
        }
        if (recognizer instanceof JSONLexer) {
            String expectingKey = this.getExpectingKey(s);
            ArrayList<String> expectingStrs = new ArrayList<String>();
            expectingStrs.add(KeySymbol.TOKEN.val());
            this.expecting.add(i1, expectingKey, expectingStrs);
        }
    }

    private String getExpectingKey(String s) {
        String expectingKey = s.substring(s.indexOf("'") + 1, s.lastIndexOf("'"));
        int lastIndexOfLF = expectingKey.lastIndexOf("\\n");
        if (lastIndexOfLF == -1) {
            lastIndexOfLF = expectingKey.lastIndexOf("\\r");
        }
        if (lastIndexOfLF == -1) {
            lastIndexOfLF = expectingKey.lastIndexOf("\\r\\n");
        }
        if (lastIndexOfLF != -1) {
            expectingKey = expectingKey.substring(0, lastIndexOfLF);
        }
        return expectingKey;
    }

    public void reportAmbiguity(Parser parser, DFA dfa, int i, int i1, boolean b, BitSet bitSet, ATNConfigSet atnConfigSet) {
    }

    public void reportAttemptingFullContext(Parser parser, DFA dfa, int i, int i1, BitSet bitSet, ATNConfigSet atnConfigSet) {
    }

    public void reportContextSensitivity(Parser parser, DFA dfa, int i, int i1, int i2, ATNConfigSet atnConfigSet) {
    }
}

