/*
 * Decompiled with CFR 0.152.
 */
package io.github.haibiiin.json.repair.strategy;

import io.github.haibiiin.json.repair.Expecting;
import io.github.haibiiin.json.repair.ExtractStrategy;
import io.github.haibiiin.json.repair.antlr.KeySymbol;
import io.github.haibiiin.json.repair.antlr.autogen.JSONParser;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class SimpleExtractStrategy
implements ExtractStrategy {
    @Override
    public String extract(String content, List<ParseTree> beRepairParseList, Expecting expecting) {
        if (this.validParseTreeList(beRepairParseList)) {
            ParseTree parseTree = beRepairParseList.get(1);
            if (parseTree instanceof JSONParser.ObjContext) {
                int start = ((JSONParser.ObjContext)parseTree).getStart().getStartIndex();
                int end = ((JSONParser.ObjContext)parseTree).getStop().getStopIndex() + 1;
                return content.substring(start, end);
            }
            if (parseTree instanceof JSONParser.ArrContext) {
                int start = ((JSONParser.ArrContext)parseTree).getStart().getStartIndex();
                int end = ((JSONParser.ArrContext)parseTree).getStop().getStopIndex() + 1;
                return content.substring(start, end);
            }
            if (parseTree instanceof JSONParser.ValueContext) {
                int start = ((JSONParser.ValueContext)parseTree).getStart().getStartIndex();
                int end = ((JSONParser.ValueContext)parseTree).getStop().getStopIndex() + 1;
                return content.substring(start, end);
            }
            if (parseTree instanceof TerminalNode) {
                String symbol = ((TerminalNode)parseTree).getSymbol().getText();
                if (KeySymbol.TRUE.val().equalsIgnoreCase(symbol.toLowerCase()) || KeySymbol.FALSE.val().equalsIgnoreCase(symbol.toLowerCase()) || KeySymbol.NULL.val().equalsIgnoreCase(symbol.toLowerCase())) {
                    return symbol;
                }
                if (beRepairParseList.size() == 3 && beRepairParseList.get(2) instanceof TerminalNode && KeySymbol.EOF.val().equalsIgnoreCase(((TerminalNode)beRepairParseList.get(2)).getSymbol().getText())) {
                    return symbol;
                }
            }
        }
        return content;
    }

    private boolean validParseTreeList(List<ParseTree> parseTreeList) {
        return parseTreeList.size() >= 2 && parseTreeList.get(0) instanceof JSONParser.ValueContext;
    }
}

