/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.console;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ConsoleCaptor
implements AutoCloseable {
    private final PrintStream originalOut = System.out;
    private final PrintStream originalErr = System.err;
    private ByteArrayOutputStream outputStreamForOut = new ByteArrayOutputStream();
    private ByteArrayOutputStream outputStreamForErr = new ByteArrayOutputStream();
    private PrintStream consoleCaptorForOut = new PrintStream(this.outputStreamForOut);
    private PrintStream consoleCaptorForErr = new PrintStream(this.outputStreamForErr);

    public ConsoleCaptor() {
        System.setOut(this.consoleCaptorForOut);
        System.setErr(this.consoleCaptorForErr);
    }

    public List<String> getStandardOutput() {
        return this.getContent(this.outputStreamForOut);
    }

    public List<String> getErrorOutput() {
        return this.getContent(this.outputStreamForErr);
    }

    private List<String> getContent(ByteArrayOutputStream outputStream) {
        return Stream.of(outputStream.toString().split(System.lineSeparator())).map(String::trim).filter(line -> !line.isEmpty()).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public void clearOutput() {
        this.closeStreams();
        this.reset();
    }

    @Override
    public void close() {
        this.rollBackConfiguration();
        this.closeStreams();
    }

    private void closeStreams() {
        try {
            this.outputStreamForOut.flush();
            this.outputStreamForErr.flush();
            this.consoleCaptorForOut.flush();
            this.consoleCaptorForErr.flush();
            this.outputStreamForOut.close();
            this.outputStreamForErr.close();
            this.consoleCaptorForOut.close();
            this.consoleCaptorForErr.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void reset() {
        this.outputStreamForOut = new ByteArrayOutputStream();
        this.outputStreamForErr = new ByteArrayOutputStream();
        this.consoleCaptorForOut = new PrintStream(this.outputStreamForOut);
        this.consoleCaptorForErr = new PrintStream(this.outputStreamForErr);
    }

    private void rollBackConfiguration() {
        System.setOut(this.originalOut);
        System.setErr(this.originalErr);
    }
}

