/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.console;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ConsoleCaptor
implements AutoCloseable {
    private static final PrintStream originalOut = System.out;
    private static final PrintStream originalErr = System.err;
    private ByteArrayOutputStream outputStreamForOut;
    private ByteArrayOutputStream outputStreamForErr;
    private PrintStream consoleCaptorForOut;
    private PrintStream consoleCaptorForErr;
    private final boolean allowEmptyLines;
    private final boolean allowTrimmingWhiteSpace;

    public ConsoleCaptor() {
        this(false, true);
    }

    private ConsoleCaptor(boolean allowEmptyLines, boolean allowTrimmingWhiteSpace) {
        this.createStreams();
        this.insertStreamsToSystemOut();
        this.allowEmptyLines = allowEmptyLines;
        this.allowTrimmingWhiteSpace = allowTrimmingWhiteSpace;
    }

    private void createStreams() {
        this.outputStreamForOut = new ByteArrayOutputStream();
        this.outputStreamForErr = new ByteArrayOutputStream();
        this.consoleCaptorForOut = new PrintStream(this.outputStreamForOut);
        this.consoleCaptorForErr = new PrintStream(this.outputStreamForErr);
    }

    private void insertStreamsToSystemOut() {
        System.setOut(this.consoleCaptorForOut);
        System.setErr(this.consoleCaptorForErr);
    }

    public List<String> getStandardOutput() {
        return this.getContent(this.outputStreamForOut);
    }

    public List<String> getErrorOutput() {
        return this.getContent(this.outputStreamForErr);
    }

    private List<String> getContent(ByteArrayOutputStream outputStream) {
        return Stream.of(outputStream.toString().split(System.lineSeparator())).map(line -> this.allowTrimmingWhiteSpace ? line.trim() : line).filter(line -> this.allowEmptyLines || !line.isEmpty()).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public void clearOutput() {
        this.closeExistingStreams();
        this.createStreams();
        this.insertStreamsToSystemOut();
    }

    private void closeExistingStreams() {
        try {
            this.outputStreamForOut.flush();
            this.outputStreamForErr.flush();
            this.consoleCaptorForOut.flush();
            this.consoleCaptorForErr.flush();
            this.outputStreamForOut.close();
            this.outputStreamForErr.close();
            this.consoleCaptorForOut.close();
            this.consoleCaptorForErr.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void close() {
        this.rollBackConfiguration();
        this.closeExistingStreams();
    }

    private void rollBackConfiguration() {
        System.setOut(originalOut);
        System.setErr(originalErr);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean allowEmptyLines = false;
        private boolean allowTrimmingWhiteSpace = true;

        private Builder() {
        }

        public Builder allowEmptyLines(boolean allowEmptyLines) {
            this.allowEmptyLines = allowEmptyLines;
            return this;
        }

        public Builder allowTrimmingWhiteSpace(boolean allowTrimmingWhiteSpace) {
            this.allowTrimmingWhiteSpace = allowTrimmingWhiteSpace;
            return this;
        }

        public ConsoleCaptor build() {
            return new ConsoleCaptor(this.allowEmptyLines, this.allowTrimmingWhiteSpace);
        }
    }
}

