/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.read.ListAppender;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;

public class LogCaptor<T> {
    private static final Map<String, Level> LOG_LEVEL_CONTAINER = new HashMap<String, Level>();
    private final Logger logger;
    private final ListAppender<ILoggingEvent> listAppender = new ListAppender();

    private LogCaptor(Class<T> clazz) {
        this.logger = (Logger)LoggerFactory.getLogger(clazz);
        if (!LOG_LEVEL_CONTAINER.containsKey(this.logger.getName())) {
            LOG_LEVEL_CONTAINER.put(this.logger.getName(), this.logger.getEffectiveLevel());
        }
        this.listAppender.start();
        this.logger.addAppender(this.listAppender);
    }

    public static <T> LogCaptor<T> forClass(Class<T> clazz) {
        return new LogCaptor<T>(clazz);
    }

    public List<String> getLogs() {
        return this.listAppender.list.stream().map(ILoggingEvent::getFormattedMessage).collect(Collectors.toList());
    }

    public List<String> getInfoLogs() {
        return this.getLogs(Level.INFO);
    }

    public List<String> getDebugLogs() {
        return this.getLogs(Level.DEBUG);
    }

    public List<String> getWarnLogs() {
        return this.getLogs(Level.WARN);
    }

    public List<String> getErrorLogs() {
        return this.getLogs(Level.ERROR);
    }

    public List<String> getTraceLogs() {
        return this.getLogs(Level.TRACE);
    }

    private List<String> getLogs(Level level) {
        return this.listAppender.list.stream().filter(logEvent -> logEvent.getLevel() == level).map(ILoggingEvent::getFormattedMessage).collect(Collectors.toList());
    }

    public void setLogLevelToInfo() {
        this.logger.setLevel(Level.INFO);
    }

    public void setLogLevelToDebug() {
        this.logger.setLevel(Level.DEBUG);
    }

    public void setLogLevelToTrace() {
        this.logger.setLevel(Level.TRACE);
    }

    public void resetLogLevel() {
        Optional.ofNullable(LOG_LEVEL_CONTAINER.get(this.logger.getName())).ifPresent(arg_0 -> ((Logger)this.logger).setLevel(arg_0));
    }

    public void clearLogs() {
        this.listAppender.list.clear();
    }
}

