/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.log.model;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class LogEvent {
    private final String message;
    private final String formattedMessage;
    private final String level;
    private final ZonedDateTime timeStamp;
    private final List<Object> arguments;
    private final Throwable throwable;

    public LogEvent(String message, String formattedMessage, String level, ZonedDateTime timeStamp, List<Object> arguments, Throwable throwable) {
        this.message = Objects.requireNonNull(message);
        this.formattedMessage = Objects.requireNonNull(formattedMessage);
        this.level = Objects.requireNonNull(level);
        this.timeStamp = Objects.requireNonNull(timeStamp);
        this.throwable = throwable;
        this.arguments = arguments;
    }

    public String getMessage() {
        return this.message;
    }

    public String getFormattedMessage() {
        return this.formattedMessage;
    }

    public String getLevel() {
        return this.level;
    }

    public ZonedDateTime getTimeStamp() {
        return this.timeStamp;
    }

    public List<Object> getArguments() {
        return this.arguments;
    }

    public Optional<Throwable> getThrowable() {
        return Optional.ofNullable(this.throwable);
    }
}

