/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.read.ListAppender;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import nl.altindag.log.model.LogEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public final class LogCaptor
implements AutoCloseable {
    private static final Map<String, Level> LOG_LEVEL_CONTAINER = new HashMap<String, Level>();
    private final ch.qos.logback.classic.Logger logger;
    private final ListAppender<ILoggingEvent> listAppender;

    private LogCaptor(String name) {
        Logger slf4jLogger = LoggerFactory.getLogger((String)name);
        if (!(slf4jLogger instanceof ch.qos.logback.classic.Logger)) {
            throw new IllegalArgumentException(String.format("SLF4J Logger implementation should be of the type [%s] but found [%s]. Please remove any other SLF4J implementations during the test phase from your classpath of your project. See here for an example configurations: https://github.com/Hakky54/log-captor#using-log-captor-alongside-with-other-logging-libraries", ch.qos.logback.classic.Logger.class.getName(), slf4jLogger.getClass().getName()));
        }
        this.logger = (ch.qos.logback.classic.Logger)slf4jLogger;
        this.listAppender = new ListAppender();
        this.listAppender.setName("log-captor");
        if (!LOG_LEVEL_CONTAINER.containsKey(this.logger.getName())) {
            LOG_LEVEL_CONTAINER.put(this.logger.getName(), this.logger.getEffectiveLevel());
        }
        this.listAppender.start();
        this.logger.addAppender(this.listAppender);
        if (!SLF4JBridgeHandler.isInstalled()) {
            SLF4JBridgeHandler.removeHandlersForRootLogger();
            SLF4JBridgeHandler.install();
        }
        String loggerNameForJul = "ROOT".equals(name) ? "" : name;
        java.util.logging.Logger.getLogger(loggerNameForJul).setLevel(java.util.logging.Level.ALL);
    }

    public static LogCaptor forRoot() {
        return new LogCaptor("ROOT");
    }

    public static <T> LogCaptor forClass(Class<T> clazz) {
        return new LogCaptor(clazz.getName());
    }

    public static LogCaptor forName(String name) {
        return new LogCaptor(name);
    }

    public List<String> getLogs() {
        return this.listAppender.list.stream().map(ILoggingEvent::getFormattedMessage).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public List<String> getInfoLogs() {
        return this.getLogs(Level.INFO);
    }

    public List<String> getDebugLogs() {
        return this.getLogs(Level.DEBUG);
    }

    public List<String> getWarnLogs() {
        return this.getLogs(Level.WARN);
    }

    public List<String> getErrorLogs() {
        return this.getLogs(Level.ERROR);
    }

    public List<String> getTraceLogs() {
        return this.getLogs(Level.TRACE);
    }

    private List<String> getLogs(Level level) {
        return this.listAppender.list.stream().filter(logEvent -> logEvent.getLevel() == level).map(ILoggingEvent::getFormattedMessage).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public List<LogEvent> getLogEvents() {
        return this.listAppender.list.stream().map(LogCaptor::toLogEvent).collect(Collectors.toList());
    }

    private static LogEvent toLogEvent(ILoggingEvent iLoggingEvent) {
        String message = iLoggingEvent.getMessage();
        String formattedMessage = iLoggingEvent.getFormattedMessage();
        String level = iLoggingEvent.getLevel().toString();
        String loggerName = iLoggingEvent.getLoggerName();
        ZonedDateTime timeStamp = ZonedDateTime.ofInstant(Instant.ofEpochMilli(iLoggingEvent.getTimeStamp()), ZoneOffset.UTC);
        Map<String, String> diagnosticContext = Collections.unmodifiableMap(iLoggingEvent.getMDCPropertyMap());
        List arguments = Optional.ofNullable(iLoggingEvent.getArgumentArray()).map(Arrays::asList).map(Collections::unmodifiableList).orElseGet(Collections::emptyList);
        Throwable throwable = Optional.ofNullable(iLoggingEvent.getThrowableProxy()).filter(ThrowableProxy.class::isInstance).map(ThrowableProxy.class::cast).map(ThrowableProxy::getThrowable).orElse(null);
        return new LogEvent(message, formattedMessage, level, loggerName, timeStamp, arguments, throwable, diagnosticContext);
    }

    public void addFilter(Filter<ILoggingEvent> filter) {
        this.listAppender.addFilter(filter);
        filter.start();
    }

    public void setLogLevelToInfo() {
        this.logger.setLevel(Level.INFO);
    }

    public void setLogLevelToDebug() {
        this.logger.setLevel(Level.DEBUG);
    }

    public void setLogLevelToTrace() {
        this.logger.setLevel(Level.TRACE);
    }

    public void disableLogs() {
        this.logger.setLevel(Level.OFF);
    }

    public void resetLogLevel() {
        Optional.ofNullable(LOG_LEVEL_CONTAINER.get(this.logger.getName())).ifPresent(arg_0 -> ((ch.qos.logback.classic.Logger)this.logger).setLevel(arg_0));
    }

    public void clearLogs() {
        this.listAppender.list.clear();
    }

    @Override
    public void close() {
        this.listAppender.stop();
        this.logger.detachAppender(this.listAppender);
    }
}

