/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.read.ListAppender;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import nl.altindag.log.model.LogEvent;
import nl.altindag.log.util.JavaUtilLoggingLoggerUtils;
import nl.altindag.log.util.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogCaptor
implements AutoCloseable {
    private static final Map<String, Level> LOG_LEVEL_CONTAINER = new HashMap<String, Level>();
    private final ch.qos.logback.classic.Logger logger;
    private final ListAppender<ILoggingEvent> listAppender;

    private LogCaptor(String loggerName) {
        Logger slf4jLogger = LoggerFactory.getLogger((String)loggerName);
        if (!(slf4jLogger instanceof ch.qos.logback.classic.Logger)) {
            throw new IllegalArgumentException(String.format("SLF4J Logger implementation should be of the type [%s] but found [%s]. Please remove any other SLF4J implementations during the test phase from your classpath of your project. See here for an example configurations: https://github.com/Hakky54/log-captor#using-log-captor-alongside-with-other-logging-libraries", ch.qos.logback.classic.Logger.class.getName(), slf4jLogger.getClass().getName()));
        }
        this.logger = (ch.qos.logback.classic.Logger)slf4jLogger;
        this.listAppender = new ListAppender();
        this.listAppender.setName("log-captor");
        this.listAppender.start();
        this.logger.addAppender(this.listAppender);
        JavaUtilLoggingLoggerUtils.redirectToSlf4j(loggerName);
        LOG_LEVEL_CONTAINER.putIfAbsent(this.logger.getName(), this.logger.getEffectiveLevel());
    }

    public static LogCaptor forRoot() {
        return new LogCaptor("ROOT");
    }

    public static LogCaptor forClass(Class<?> clazz) {
        return new LogCaptor(clazz.getName());
    }

    public static LogCaptor forName(String name) {
        return new LogCaptor(name);
    }

    public List<String> getLogs() {
        return this.listAppender.list.stream().map(ILoggingEvent::getFormattedMessage).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public List<String> getInfoLogs() {
        return this.getLogs(Level.INFO);
    }

    public List<String> getDebugLogs() {
        return this.getLogs(Level.DEBUG);
    }

    public List<String> getWarnLogs() {
        return this.getLogs(Level.WARN);
    }

    public List<String> getErrorLogs() {
        return this.getLogs(Level.ERROR);
    }

    public List<String> getTraceLogs() {
        return this.getLogs(Level.TRACE);
    }

    private List<String> getLogs(Level level) {
        return this.listAppender.list.stream().filter(logEvent -> logEvent.getLevel() == level).map(ILoggingEvent::getFormattedMessage).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public List<LogEvent> getLogEvents() {
        return this.listAppender.list.stream().map(Mappers.toLogEvent()).collect(Collectors.toList());
    }

    public void addFilter(Filter<ILoggingEvent> filter) {
        this.listAppender.addFilter(filter);
        filter.start();
    }

    public void setLogLevelToInfo() {
        this.logger.setLevel(Level.INFO);
    }

    public void setLogLevelToDebug() {
        this.logger.setLevel(Level.DEBUG);
    }

    public void setLogLevelToTrace() {
        this.logger.setLevel(Level.TRACE);
    }

    public void disableLogs() {
        this.logger.setLevel(Level.OFF);
    }

    public void resetLogLevel() {
        Optional.ofNullable(LOG_LEVEL_CONTAINER.get(this.logger.getName())).ifPresent(arg_0 -> ((ch.qos.logback.classic.Logger)this.logger).setLevel(arg_0));
    }

    public void clearLogs() {
        this.listAppender.list.clear();
    }

    @Override
    public void close() {
        this.listAppender.stop();
        this.logger.detachAppender(this.listAppender);
    }
}

