/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.log.model;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class LogEvent {
    private final String message;
    private final String formattedMessage;
    private final String level;
    private final String loggerName;
    private final String threadName;
    private final ZonedDateTime timeStamp;
    private final List<Object> arguments;
    private final Throwable throwable;
    private final Map<String, String> diagnosticContext;

    public LogEvent(String message, String formattedMessage, String level, String loggerName, String threadName, ZonedDateTime timeStamp, List<Object> arguments, Throwable throwable, Map<String, String> diagnosticContext) {
        this.message = Objects.requireNonNull(message);
        this.formattedMessage = Objects.requireNonNull(formattedMessage);
        this.level = Objects.requireNonNull(level);
        this.loggerName = loggerName;
        this.threadName = threadName;
        this.timeStamp = Objects.requireNonNull(timeStamp);
        this.throwable = throwable;
        this.arguments = arguments;
        this.diagnosticContext = diagnosticContext;
    }

    public String getMessage() {
        return this.message;
    }

    public String getFormattedMessage() {
        return this.formattedMessage;
    }

    public String getLevel() {
        return this.level;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public ZonedDateTime getTimeStamp() {
        return this.timeStamp;
    }

    public List<Object> getArguments() {
        return this.arguments;
    }

    public Optional<Throwable> getThrowable() {
        return Optional.ofNullable(this.throwable);
    }

    public Map<String, String> getDiagnosticContext() {
        return this.diagnosticContext;
    }
}

