/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.ssl.server.service;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.StandardCharsets;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.X509ExtendedKeyManager;
import nl.altindag.ssl.SSLFactory;
import nl.altindag.ssl.server.exception.ServerException;
import nl.altindag.ssl.server.service.Server;

class NettyServer
implements Server {
    private final ChannelFuture httpChannel;
    private final NioEventLoopGroup bossGroup;
    private final NioEventLoopGroup workerGroup;

    NettyServer(SSLFactory sslFactory, int port, String responseBody) {
        X509ExtendedKeyManager keyManager = (X509ExtendedKeyManager)sslFactory.getKeyManager().orElseThrow(NullPointerException::new);
        SslContextBuilder sslContextBuilder = SslContextBuilder.forServer((KeyManager)keyManager).ciphers((Iterable)sslFactory.getCiphers(), (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).protocols((Iterable)sslFactory.getProtocols()).clientAuth(NettyServer.getClientAuth(sslFactory.getSslParameters()));
        sslFactory.getTrustManager().ifPresent(arg_0 -> ((SslContextBuilder)sslContextBuilder).trustManager(arg_0));
        try {
            SslContext sslContext = sslContextBuilder.build();
            this.bossGroup = new NioEventLoopGroup(1);
            this.workerGroup = new NioEventLoopGroup();
            ServerBootstrap serverBootstrap = new ServerBootstrap();
            serverBootstrap.option(ChannelOption.SO_BACKLOG, (Object)1024);
            ((ServerBootstrap)serverBootstrap.group((EventLoopGroup)this.bossGroup, (EventLoopGroup)this.workerGroup).channelFactory(NioServerSocketChannel::new)).childHandler((ChannelHandler)new ServerInitializer(sslContext, responseBody));
            this.httpChannel = serverBootstrap.bind(port).sync();
        }
        catch (InterruptedException | SSLException e) {
            throw new ServerException(e);
        }
    }

    @Override
    public void stop() {
        this.httpChannel.channel().close();
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
    }

    static ClientAuth getClientAuth(SSLParameters sslParameters) {
        if (sslParameters.getNeedClientAuth()) {
            return ClientAuth.REQUIRE;
        }
        if (sslParameters.getWantClientAuth()) {
            return ClientAuth.OPTIONAL;
        }
        return ClientAuth.NONE;
    }

    private static class ServerHandler
    extends ChannelInboundHandlerAdapter {
        private final String responseBody;

        public ServerHandler(String responseBody) {
            this.responseBody = responseBody;
        }

        public void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
            channelHandlerContext.flush();
        }

        public void channelRead(ChannelHandlerContext channelHandlerContext, Object message) {
            if (message instanceof HttpRequest) {
                HttpRequest request = (HttpRequest)message;
                if (HttpUtil.is100ContinueExpected((HttpMessage)request)) {
                    channelHandlerContext.write((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
                }
                boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)request);
                DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])this.responseBody.getBytes(StandardCharsets.UTF_8)));
                response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain");
                response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
                if (!keepAlive) {
                    channelHandlerContext.write((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                } else {
                    response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
                    channelHandlerContext.write((Object)response);
                }
            }
        }

        public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
            throwable.printStackTrace();
            channelHandlerContext.close();
        }
    }

    private static class ServerInitializer
    extends ChannelInitializer<Channel> {
        private final SslContext sslContext;
        private final String responseBody;

        public ServerInitializer(SslContext sslContext, String responseBody) {
            this.sslContext = sslContext;
            this.responseBody = responseBody;
        }

        protected void initChannel(Channel channel) {
            channel.pipeline().addFirst("ssl", (ChannelHandler)new SslHandler(this.sslContext.newEngine(channel.alloc()))).addLast(new ChannelHandler[]{new HttpServerCodec()}).addLast(new ChannelHandler[]{new ServerHandler(this.responseBody)});
        }
    }
}

