/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.ssl.server.service;

import nl.altindag.ssl.SSLFactory;
import nl.altindag.ssl.server.service.NettyServer;

public interface Server {
    public void stop();

    public static Server createDefault(SSLFactory sslFactory) {
        return Server.createDefault(sslFactory, 8443);
    }

    public static Server createDefault(SSLFactory sslFactory, int port) {
        return Server.createDefault(sslFactory, port, "Hello World!");
    }

    public static Server createDefault(SSLFactory sslFactory, int port, String responseBody) {
        return Server.builder(sslFactory).withPort(port).withResponseBody(responseBody).withDelayedResponseTime(-1).build();
    }

    public static Builder builder(SSLFactory sslFactory) {
        return new Builder(sslFactory);
    }

    public static class Builder {
        private final SSLFactory sslFactory;
        private int port = 8443;
        private String responseBody = "Hello World!";
        private int delayResponseTimeInMilliseconds = -1;

        private Builder(SSLFactory sslFactory) {
            this.sslFactory = sslFactory;
        }

        public Builder withPort(int port) {
            this.port = port;
            return this;
        }

        public Builder withResponseBody(String responseBody) {
            this.responseBody = responseBody;
            return this;
        }

        public Builder withDelayedResponseTime(int delayResponseTimeInMilliseconds) {
            this.delayResponseTimeInMilliseconds = delayResponseTimeInMilliseconds;
            return this;
        }

        public Server build() {
            return new NettyServer(this.sslFactory, this.port, this.responseBody, this.delayResponseTimeInMilliseconds);
        }
    }
}

