/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.ssl.util;

import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.X509ExtendedKeyManager;
import nl.altindag.ssl.SSLFactory;

public final class NettySslUtils {
    private NettySslUtils() {
    }

    public static SslContextBuilder forClient(SSLFactory sslFactory) {
        SslContextBuilder sslContextBuilder = SslContextBuilder.forClient().ciphers((Iterable)sslFactory.getCiphers(), (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).protocols((Iterable)sslFactory.getProtocols());
        sslFactory.getKeyManager().ifPresent(arg_0 -> ((SslContextBuilder)sslContextBuilder).keyManager(arg_0));
        sslFactory.getTrustManager().ifPresent(arg_0 -> ((SslContextBuilder)sslContextBuilder).trustManager(arg_0));
        return sslContextBuilder;
    }

    public static SslContextBuilder forServer(SSLFactory sslFactory) {
        X509ExtendedKeyManager keyManager = (X509ExtendedKeyManager)sslFactory.getKeyManager().orElseThrow(NullPointerException::new);
        SslContextBuilder sslContextBuilder = SslContextBuilder.forServer((KeyManager)keyManager).ciphers((Iterable)sslFactory.getCiphers(), (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).protocols((Iterable)sslFactory.getProtocols()).clientAuth(NettySslUtils.getClientAuth(sslFactory.getSslParameters()));
        sslFactory.getTrustManager().ifPresent(arg_0 -> ((SslContextBuilder)sslContextBuilder).trustManager(arg_0));
        return sslContextBuilder;
    }

    private static ClientAuth getClientAuth(SSLParameters sslParameters) {
        if (sslParameters.getNeedClientAuth()) {
            return ClientAuth.REQUIRE;
        }
        if (sslParameters.getWantClientAuth()) {
            return ClientAuth.OPTIONAL;
        }
        return ClientAuth.NONE;
    }
}

