/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.ssl.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import nl.altindag.ssl.exception.CertificateParseException;
import nl.altindag.ssl.exception.GenericIOException;
import nl.altindag.ssl.exception.GenericKeyStoreException;
import nl.altindag.ssl.exception.PrivateKeyParseException;
import nl.altindag.ssl.util.CertificateUtils;
import nl.altindag.ssl.util.IOUtils;
import nl.altindag.ssl.util.KeyManagerUtils;
import nl.altindag.ssl.util.KeyStoreUtils;
import nl.altindag.ssl.util.TrustManagerUtils;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.X509TrustedCertificateBlock;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;

public final class PemUtils {
    private static final char[] DUMMY_PASSWORD = "dummy-password".toCharArray();
    private static final char[] NO_PASSWORD = null;
    private static final BouncyCastleProvider BOUNCY_CASTLE_PROVIDER = new BouncyCastleProvider();
    private static final JcaPEMKeyConverter KEY_CONVERTER = new JcaPEMKeyConverter().setProvider((Provider)BOUNCY_CASTLE_PROVIDER);
    private static final JcaX509CertificateConverter CERTIFICATE_CONVERTER = new JcaX509CertificateConverter().setProvider((Provider)BOUNCY_CASTLE_PROVIDER);
    private static final JceOpenSSLPKCS8DecryptorProviderBuilder OPEN_SSL_PKCS8_DECRYPTOR_PROVIDER_BUILDER = new JceOpenSSLPKCS8DecryptorProviderBuilder().setProvider((Provider)BOUNCY_CASTLE_PROVIDER);
    private static final JcePEMDecryptorProviderBuilder PEM_DECRYPTOR_PROVIDER_BUILDER = new JcePEMDecryptorProviderBuilder().setProvider((Provider)BOUNCY_CASTLE_PROVIDER);
    private static final BouncyFunction<char[], InputDecryptorProvider> INPUT_DECRYPTOR_PROVIDER = password -> OPEN_SSL_PKCS8_DECRYPTOR_PROVIDER_BUILDER.build(Objects.requireNonNull(password));
    private static final BouncyFunction<char[], PEMDecryptorProvider> PEM_DECRYPTOR_PROVIDER = password -> PEM_DECRYPTOR_PROVIDER_BUILDER.build(Objects.requireNonNull(password));

    private PemUtils() {
    }

    public static X509ExtendedTrustManager loadTrustMaterial(String ... certificatePaths) {
        List<X509Certificate> certificates = PemUtils.loadCertificate(certificatePaths, PemUtils::getResourceAsStream);
        return PemUtils.mapTrustMaterial(certificates);
    }

    public static X509ExtendedTrustManager loadTrustMaterial(Path ... certificatePaths) {
        List<X509Certificate> certificates = PemUtils.loadCertificate(certificatePaths, PemUtils::getFileAsStream);
        return PemUtils.mapTrustMaterial(certificates);
    }

    public static X509ExtendedTrustManager loadTrustMaterial(InputStream ... certificateStreams) {
        List<X509Certificate> certificates = PemUtils.loadCertificate(certificateStreams, Function.identity());
        return PemUtils.mapTrustMaterial(certificates);
    }

    private static <T> List<X509Certificate> loadCertificate(T[] resources, Function<T, InputStream> resourceMapper) {
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        for (T resource : resources) {
            try (InputStream certificateStream = resourceMapper.apply(resource);){
                certificates.addAll(PemUtils.parseCertificate(certificateStream));
            }
            catch (Exception e) {
                throw new GenericIOException((Throwable)e);
            }
        }
        return Collections.unmodifiableList(certificates);
    }

    private static List<X509Certificate> parseCertificate(InputStream certificateStream) {
        String content = IOUtils.getContent((InputStream)certificateStream);
        return PemUtils.parseCertificate(content);
    }

    private static List<X509Certificate> parseCertificate(String certContent) {
        try {
            StringReader stringReader = new StringReader(certContent);
            PEMParser pemParser = new PEMParser((Reader)stringReader);
            ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
            Object object = pemParser.readObject();
            while (object != null) {
                if (object instanceof X509CertificateHolder) {
                    X509Certificate certificate = CERTIFICATE_CONVERTER.getCertificate((X509CertificateHolder)object);
                    certificates.add(certificate);
                } else if (object instanceof X509TrustedCertificateBlock) {
                    X509CertificateHolder certificateHolder = ((X509TrustedCertificateBlock)object).getCertificateHolder();
                    X509Certificate certificate = CERTIFICATE_CONVERTER.getCertificate(certificateHolder);
                    certificates.add(certificate);
                }
                object = pemParser.readObject();
            }
            pemParser.close();
            ((Reader)stringReader).close();
            if (certificates.isEmpty()) {
                throw new CertificateParseException("Received an unsupported certificate type");
            }
            return certificates;
        }
        catch (IOException | CertificateException e) {
            throw new CertificateParseException(e);
        }
    }

    public static X509ExtendedTrustManager parseTrustMaterial(String ... certificateContents) {
        return Arrays.stream(certificateContents).map(PemUtils::parseCertificate).flatMap(Collection::stream).collect(Collectors.collectingAndThen(Collectors.toList(), PemUtils::mapTrustMaterial));
    }

    private static X509ExtendedTrustManager mapTrustMaterial(List<X509Certificate> certificates) {
        KeyStore trustStore = KeyStoreUtils.createTrustStore(certificates);
        return TrustManagerUtils.createTrustManager((KeyStore)trustStore);
    }

    public static X509ExtendedKeyManager loadIdentityMaterial(String certificateChainPath, String privateKeyPath) {
        return PemUtils.loadIdentityMaterial(certificateChainPath, privateKeyPath, NO_PASSWORD);
    }

    public static X509ExtendedKeyManager loadIdentityMaterial(String certificateChainPath, String privateKeyPath, char[] keyPassword) {
        return PemUtils.loadIdentityMaterial(certificateChainPath, privateKeyPath, keyPassword, PemUtils::getResourceAsStream);
    }

    public static X509ExtendedKeyManager loadIdentityMaterial(InputStream certificateChainStream, InputStream privateKeyStream) {
        return PemUtils.loadIdentityMaterial(certificateChainStream, privateKeyStream, NO_PASSWORD);
    }

    public static X509ExtendedKeyManager loadIdentityMaterial(InputStream certificateChainStream, InputStream privateKeyStream, char[] keyPassword) {
        return PemUtils.loadIdentityMaterial(certificateChainStream, privateKeyStream, keyPassword, Function.identity());
    }

    public static X509ExtendedKeyManager loadIdentityMaterial(Path certificateChainPath, Path privateKeyPath) {
        return PemUtils.loadIdentityMaterial(certificateChainPath, privateKeyPath, NO_PASSWORD);
    }

    public static X509ExtendedKeyManager loadIdentityMaterial(Path certificateChainPath, Path privateKeyPath, char[] keyPassword) {
        return PemUtils.loadIdentityMaterial(certificateChainPath, privateKeyPath, keyPassword, PemUtils::getFileAsStream);
    }

    public static X509ExtendedKeyManager loadIdentityMaterial(String identityPath) {
        return PemUtils.loadIdentityMaterial(identityPath, NO_PASSWORD);
    }

    public static X509ExtendedKeyManager loadIdentityMaterial(String identityPath, char[] keyPassword) {
        return PemUtils.loadIdentityMaterial(identityPath, keyPassword, PemUtils::getResourceAsStream);
    }

    public static X509ExtendedKeyManager loadIdentityMaterial(Path identityPath) {
        return PemUtils.loadIdentityMaterial(identityPath, NO_PASSWORD);
    }

    public static X509ExtendedKeyManager loadIdentityMaterial(Path identityPath, char[] keyPassword) {
        return PemUtils.loadIdentityMaterial(identityPath, keyPassword, PemUtils::getFileAsStream);
    }

    public static X509ExtendedKeyManager loadIdentityMaterial(InputStream identityStream) {
        return PemUtils.loadIdentityMaterial(identityStream, NO_PASSWORD);
    }

    public static X509ExtendedKeyManager loadIdentityMaterial(InputStream identityStream, char[] keyPassword) {
        return PemUtils.loadIdentityMaterial(identityStream, keyPassword, Function.identity());
    }

    /*
     * Exception decompiling
     */
    private static <T> X509ExtendedKeyManager loadIdentityMaterial(T certificateChain, T privateKey, char[] keyPassword, Function<T, InputStream> resourceMapper) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> X509ExtendedKeyManager loadIdentityMaterial(T identity, char[] keyPassword, Function<T, InputStream> resourceMapper) {
        try (InputStream identityStream = resourceMapper.apply(identity);){
            String identityContent = IOUtils.getContent((InputStream)identityStream);
            X509ExtendedKeyManager x509ExtendedKeyManager = PemUtils.parseIdentityMaterial(identityContent, identityContent, keyPassword);
            return x509ExtendedKeyManager;
        }
        catch (IOException exception) {
            throw new GenericIOException((Throwable)exception);
        }
    }

    public static X509ExtendedKeyManager parseIdentityMaterial(String identityContent, char[] keyPassword) {
        return PemUtils.parseIdentityMaterial(identityContent, identityContent, keyPassword);
    }

    public static X509ExtendedKeyManager parseIdentityMaterial(String certificateChainContent, String privateKeyContent, char[] keyPassword) {
        PrivateKey privateKey = PemUtils.parsePrivateKey(privateKeyContent, keyPassword);
        Certificate[] certificateChain = PemUtils.parseCertificate(certificateChainContent).toArray(new Certificate[0]);
        return PemUtils.parseIdentityMaterial(certificateChain, privateKey);
    }

    private static PrivateKey parsePrivateKey(String identityContent, char[] keyPassword) {
        try {
            StringReader stringReader = new StringReader(identityContent);
            PEMParser pemParser = new PEMParser((Reader)stringReader);
            PrivateKeyInfo privateKeyInfo = null;
            Object object = pemParser.readObject();
            while (object != null && privateKeyInfo == null) {
                if (object instanceof PrivateKeyInfo) {
                    privateKeyInfo = (PrivateKeyInfo)object;
                } else if (object instanceof PKCS8EncryptedPrivateKeyInfo) {
                    InputDecryptorProvider inputDecryptorProvider = INPUT_DECRYPTOR_PROVIDER.apply(keyPassword);
                    privateKeyInfo = ((PKCS8EncryptedPrivateKeyInfo)object).decryptPrivateKeyInfo(inputDecryptorProvider);
                } else if (object instanceof PEMKeyPair) {
                    privateKeyInfo = ((PEMKeyPair)object).getPrivateKeyInfo();
                } else if (object instanceof PEMEncryptedKeyPair) {
                    PEMDecryptorProvider pemDecryptorProvider = PEM_DECRYPTOR_PROVIDER.apply(keyPassword);
                    PEMKeyPair pemKeyPair = ((PEMEncryptedKeyPair)object).decryptKeyPair(pemDecryptorProvider);
                    privateKeyInfo = pemKeyPair.getPrivateKeyInfo();
                }
                if (privateKeyInfo != null) continue;
                object = pemParser.readObject();
            }
            pemParser.close();
            ((Reader)stringReader).close();
            if (Objects.isNull(privateKeyInfo)) {
                throw new PrivateKeyParseException("Received an unsupported private key type");
            }
            return KEY_CONVERTER.getPrivateKey(privateKeyInfo);
        }
        catch (IOException | OperatorCreationException | PKCSException e) {
            throw new PrivateKeyParseException(e);
        }
    }

    private static X509ExtendedKeyManager parseIdentityMaterial(Certificate[] certificatesChain, PrivateKey privateKey) {
        try {
            KeyStore keyStore = KeyStoreUtils.createKeyStore();
            keyStore.setKeyEntry(CertificateUtils.generateAlias((Certificate)certificatesChain[0]), privateKey, DUMMY_PASSWORD, certificatesChain);
            return KeyManagerUtils.createKeyManager((KeyStore)keyStore, (char[])DUMMY_PASSWORD);
        }
        catch (KeyStoreException e) {
            throw new GenericKeyStoreException((Throwable)e);
        }
    }

    protected static InputStream getResourceAsStream(String name) {
        return PemUtils.class.getClassLoader().getResourceAsStream(name);
    }

    private static InputStream getFileAsStream(Path path) {
        try {
            return Files.newInputStream(path, StandardOpenOption.READ);
        }
        catch (IOException e) {
            throw new GenericIOException((Throwable)e);
        }
    }

    @FunctionalInterface
    private static interface BouncyFunction<T, R> {
        public R apply(T var1) throws OperatorCreationException;
    }
}

