/*
 * Decompiled with CFR 0.152.
 */
package com.hw.openai;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hw.openai.common.OpenAiError;
import com.hw.openai.common.OpenaiApiType;
import com.hw.openai.entity.chat.ChatCompletion;
import com.hw.openai.entity.chat.ChatCompletionChunk;
import com.hw.openai.entity.chat.ChatCompletionResp;
import com.hw.openai.entity.completions.Completion;
import com.hw.openai.entity.completions.CompletionChunk;
import com.hw.openai.entity.completions.CompletionResp;
import com.hw.openai.entity.embeddings.Embedding;
import com.hw.openai.entity.embeddings.EmbeddingResp;
import com.hw.openai.entity.models.Model;
import com.hw.openai.entity.models.ModelResp;
import com.hw.openai.exception.OpenAiException;
import com.hw.openai.service.OpenAiService;
import com.hw.openai.stream.ResponseBodyCallback;
import com.hw.openai.stream.SSE;
import com.hw.openai.utils.ProxyUtils;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.Single;
import java.io.Closeable;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.HttpException;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class OpenAiClient
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(OpenAiClient.class);
    private String openaiApiBase;
    private String openaiApiKey;
    private OpenaiApiType openaiApiType;
    private String openaiApiVersion;
    private String openaiOrganization;
    private String openaiProxy;
    private String proxyUsername;
    private String proxyPassword;
    protected long requestTimeout;
    private List<Interceptor> interceptorList;
    private OpenAiService service;
    private OkHttpClient httpClient;
    private ObjectMapper objectMapper;

    public OpenAiClient init() {
        this.initializeOpenaiApiBase();
        this.openaiProxy = this.getOrEnvOrDefault(this.openaiProxy, "OPENAI_PROXY", new String[0]);
        OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder().connectTimeout(this.requestTimeout, TimeUnit.SECONDS).readTimeout(this.requestTimeout, TimeUnit.SECONDS).writeTimeout(this.requestTimeout, TimeUnit.SECONDS).callTimeout(this.requestTimeout, TimeUnit.SECONDS);
        httpClientBuilder.addInterceptor(chain -> {
            this.openaiApiKey = this.getOrEnvOrDefault(this.openaiApiKey, "OPENAI_API_KEY", new String[0]);
            this.openaiOrganization = this.getOrEnvOrDefault(this.openaiOrganization, "OPENAI_ORGANIZATION", "");
            Request.Builder requestBuilder = chain.request().newBuilder();
            requestBuilder.header("Content-Type", "application/json");
            if (this.isAzureApiType()) {
                requestBuilder.header("api-key", this.openaiApiKey);
            } else {
                requestBuilder.header("Authorization", "Bearer " + this.openaiApiKey);
                requestBuilder.header("OpenAI-Organization", this.openaiOrganization);
            }
            Request request = requestBuilder.build();
            return chain.proceed(request);
        });
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor(arg_0 -> ((Logger)LOG).debug(arg_0));
        loggingInterceptor.setLevel(LOG.isDebugEnabled() ? HttpLoggingInterceptor.Level.BODY : HttpLoggingInterceptor.Level.BASIC);
        httpClientBuilder.addInterceptor((Interceptor)loggingInterceptor);
        if (this.interceptorList != null) {
            this.interceptorList.forEach(arg_0 -> ((OkHttpClient.Builder)httpClientBuilder).addInterceptor(arg_0));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.openaiProxy)) {
            httpClientBuilder.proxy(ProxyUtils.http(this.openaiProxy, this.proxyUsername, this.proxyPassword));
        }
        this.httpClient = httpClientBuilder.build();
        if (this.objectMapper == null) {
            this.objectMapper = OpenAiClient.defaultObjectMapper();
        }
        Retrofit retrofit = new Retrofit.Builder().baseUrl(this.openaiApiBase).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)this.objectMapper)).client(this.httpClient).build();
        this.service = (OpenAiService)retrofit.create(OpenAiService.class);
        return this;
    }

    private void initializeOpenaiApiBase() {
        if (this.isAzureApiType()) {
            this.openaiApiBase = this.getOrEnvOrDefault(this.openaiApiBase, "OPENAI_API_BASE", new String[0]);
            if (this.openaiApiBase == null) {
                throw new NullPointerException("Did not find OPENAI_API_BASE, please add an environment variable `OPENAI_API_BASE` which contains it, or pass `OPENAI_API_BASE` as a named parameter.");
            }
            this.openaiApiBase = StringUtils.appendIfMissing((String)this.openaiApiBase, (CharSequence)"/", (CharSequence[])new CharSequence[0]) + "openai/deployments/";
        } else {
            this.openaiApiBase = this.getOrEnvOrDefault(this.openaiApiBase, "OPENAI_API_BASE", "https://api.openai.com/v1/");
        }
    }

    public static ObjectMapper defaultObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.findAndRegisterModules();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }

    private String getOrEnvOrDefault(String originalValue, String envKey, String ... defaultValue) {
        if (StringUtils.isNotEmpty((CharSequence)originalValue)) {
            return originalValue;
        }
        String envValue = System.getenv(envKey);
        if (StringUtils.isNotEmpty((CharSequence)envValue)) {
            return envValue;
        }
        if (defaultValue.length > 0) {
            return defaultValue[0];
        }
        return null;
    }

    public ModelResp listModels() {
        return this.execute(this.service.listModels());
    }

    public Model retrieveModel(String model) {
        return this.execute(this.service.retrieveModel(model));
    }

    public String completion(Completion completion) {
        CompletionResp response = this.createCompletion(completion);
        String text = response.getChoices().get(0).getText();
        return StringUtils.trim((String)text);
    }

    public CompletionResp createCompletion(Completion completion) {
        return this.isAzureApiType() ? this.execute(this.service.createCompletion(completion.getModel(), this.openaiApiVersion, completion)) : this.execute(this.service.createCompletion(completion));
    }

    public Flowable<CompletionChunk> streamCompletion(Completion completion) {
        completion.setStream(true);
        return this.stream(this.service.streamCompletion(completion), CompletionChunk.class);
    }

    public String chatCompletion(ChatCompletion chatCompletion) {
        ChatCompletionResp response = this.createChatCompletion(chatCompletion);
        String content = response.getChoices().get(0).getMessage().getContent();
        return StringUtils.trim((String)content);
    }

    public ChatCompletionResp createChatCompletion(ChatCompletion chatCompletion) {
        return this.isAzureApiType() ? this.execute(this.service.createChatCompletion(chatCompletion.getModel(), this.openaiApiVersion, chatCompletion)) : this.execute(this.service.createChatCompletion(chatCompletion));
    }

    public Flowable<ChatCompletionChunk> streamChatCompletion(ChatCompletion chatCompletion) {
        chatCompletion.setStream(true);
        return this.stream(this.service.streamChatCompletion(chatCompletion), ChatCompletionChunk.class);
    }

    public EmbeddingResp createEmbedding(Embedding embedding) {
        return this.isAzureApiType() ? this.execute(this.service.createEmbedding(embedding.getModel(), this.openaiApiVersion, embedding)) : this.execute(this.service.createEmbedding(embedding));
    }

    private boolean isAzureApiType() {
        return EnumSet.of(OpenaiApiType.AZURE, OpenaiApiType.AZURE_AD).contains((Object)this.openaiApiType);
    }

    private Flowable<SSE> stream(Call<ResponseBody> apiCall) {
        return this.stream(apiCall, false);
    }

    public Flowable<SSE> stream(Call<ResponseBody> apiCall, boolean emitDone) {
        return Flowable.create(emitter -> apiCall.enqueue((Callback)new ResponseBodyCallback((FlowableEmitter<SSE>)emitter, emitDone, this.objectMapper)), (BackpressureStrategy)BackpressureStrategy.BUFFER);
    }

    private <T> Flowable<T> stream(Call<ResponseBody> apiCall, Class<T> clazz) {
        return this.stream(apiCall).map(sse -> this.objectMapper.readValue(sse.data(), clazz));
    }

    public <T> T execute(Single<T> apiCall) {
        try {
            return (T)apiCall.blockingGet();
        }
        catch (HttpException e) {
            try {
                if (e.response() != null) {
                    try (ResponseBody responseBody = Objects.requireNonNull(e.response()).errorBody();){
                        if (responseBody != null) {
                            String errorBody = responseBody.string();
                            OpenAiError error = (OpenAiError)this.objectMapper.readValue(errorBody, OpenAiError.class);
                            throw new OpenAiException(error, (Exception)((Object)e), e.code());
                        }
                    }
                }
                throw e;
            }
            catch (IOException ex) {
                throw e;
            }
        }
    }

    @Override
    public void close() {
        this.httpClient.dispatcher().cancelAll();
        this.httpClient.connectionPool().evictAll();
        this.httpClient.dispatcher().executorService().shutdown();
    }

    private static OpenaiApiType $default$openaiApiType() {
        return OpenaiApiType.OPENAI;
    }

    private static long $default$requestTimeout() {
        return 16L;
    }

    OpenAiClient(String openaiApiBase, String openaiApiKey, OpenaiApiType openaiApiType, String openaiApiVersion, String openaiOrganization, String openaiProxy, String proxyUsername, String proxyPassword, long requestTimeout, List<Interceptor> interceptorList, OpenAiService service, OkHttpClient httpClient, ObjectMapper objectMapper) {
        this.openaiApiBase = openaiApiBase;
        this.openaiApiKey = openaiApiKey;
        this.openaiApiType = openaiApiType;
        this.openaiApiVersion = openaiApiVersion;
        this.openaiOrganization = openaiOrganization;
        this.openaiProxy = openaiProxy;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        this.requestTimeout = requestTimeout;
        this.interceptorList = interceptorList;
        this.service = service;
        this.httpClient = httpClient;
        this.objectMapper = objectMapper;
    }

    public static OpenAiClientBuilder builder() {
        return new OpenAiClientBuilder();
    }

    public String getOpenaiApiBase() {
        return this.openaiApiBase;
    }

    public String getOpenaiApiKey() {
        return this.openaiApiKey;
    }

    public OpenaiApiType getOpenaiApiType() {
        return this.openaiApiType;
    }

    public String getOpenaiApiVersion() {
        return this.openaiApiVersion;
    }

    public String getOpenaiOrganization() {
        return this.openaiOrganization;
    }

    public String getOpenaiProxy() {
        return this.openaiProxy;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public List<Interceptor> getInterceptorList() {
        return this.interceptorList;
    }

    public OpenAiService getService() {
        return this.service;
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setOpenaiApiBase(String openaiApiBase) {
        this.openaiApiBase = openaiApiBase;
    }

    public void setOpenaiApiKey(String openaiApiKey) {
        this.openaiApiKey = openaiApiKey;
    }

    public void setOpenaiApiType(OpenaiApiType openaiApiType) {
        this.openaiApiType = openaiApiType;
    }

    public void setOpenaiApiVersion(String openaiApiVersion) {
        this.openaiApiVersion = openaiApiVersion;
    }

    public void setOpenaiOrganization(String openaiOrganization) {
        this.openaiOrganization = openaiOrganization;
    }

    public void setOpenaiProxy(String openaiProxy) {
        this.openaiProxy = openaiProxy;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public void setRequestTimeout(long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public void setInterceptorList(List<Interceptor> interceptorList) {
        this.interceptorList = interceptorList;
    }

    public void setService(OpenAiService service) {
        this.service = service;
    }

    public void setHttpClient(OkHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenAiClient)) {
            return false;
        }
        OpenAiClient other = (OpenAiClient)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRequestTimeout() != other.getRequestTimeout()) {
            return false;
        }
        String this$openaiApiBase = this.getOpenaiApiBase();
        String other$openaiApiBase = other.getOpenaiApiBase();
        if (this$openaiApiBase == null ? other$openaiApiBase != null : !this$openaiApiBase.equals(other$openaiApiBase)) {
            return false;
        }
        String this$openaiApiKey = this.getOpenaiApiKey();
        String other$openaiApiKey = other.getOpenaiApiKey();
        if (this$openaiApiKey == null ? other$openaiApiKey != null : !this$openaiApiKey.equals(other$openaiApiKey)) {
            return false;
        }
        OpenaiApiType this$openaiApiType = this.getOpenaiApiType();
        OpenaiApiType other$openaiApiType = other.getOpenaiApiType();
        if (this$openaiApiType == null ? other$openaiApiType != null : !((Object)((Object)this$openaiApiType)).equals((Object)other$openaiApiType)) {
            return false;
        }
        String this$openaiApiVersion = this.getOpenaiApiVersion();
        String other$openaiApiVersion = other.getOpenaiApiVersion();
        if (this$openaiApiVersion == null ? other$openaiApiVersion != null : !this$openaiApiVersion.equals(other$openaiApiVersion)) {
            return false;
        }
        String this$openaiOrganization = this.getOpenaiOrganization();
        String other$openaiOrganization = other.getOpenaiOrganization();
        if (this$openaiOrganization == null ? other$openaiOrganization != null : !this$openaiOrganization.equals(other$openaiOrganization)) {
            return false;
        }
        String this$openaiProxy = this.getOpenaiProxy();
        String other$openaiProxy = other.getOpenaiProxy();
        if (this$openaiProxy == null ? other$openaiProxy != null : !this$openaiProxy.equals(other$openaiProxy)) {
            return false;
        }
        String this$proxyUsername = this.getProxyUsername();
        String other$proxyUsername = other.getProxyUsername();
        if (this$proxyUsername == null ? other$proxyUsername != null : !this$proxyUsername.equals(other$proxyUsername)) {
            return false;
        }
        String this$proxyPassword = this.getProxyPassword();
        String other$proxyPassword = other.getProxyPassword();
        if (this$proxyPassword == null ? other$proxyPassword != null : !this$proxyPassword.equals(other$proxyPassword)) {
            return false;
        }
        List<Interceptor> this$interceptorList = this.getInterceptorList();
        List<Interceptor> other$interceptorList = other.getInterceptorList();
        if (this$interceptorList == null ? other$interceptorList != null : !((Object)this$interceptorList).equals(other$interceptorList)) {
            return false;
        }
        OpenAiService this$service = this.getService();
        OpenAiService other$service = other.getService();
        if (this$service == null ? other$service != null : !this$service.equals(other$service)) {
            return false;
        }
        OkHttpClient this$httpClient = this.getHttpClient();
        OkHttpClient other$httpClient = other.getHttpClient();
        if (this$httpClient == null ? other$httpClient != null : !this$httpClient.equals(other$httpClient)) {
            return false;
        }
        ObjectMapper this$objectMapper = this.getObjectMapper();
        ObjectMapper other$objectMapper = other.getObjectMapper();
        return !(this$objectMapper == null ? other$objectMapper != null : !this$objectMapper.equals(other$objectMapper));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OpenAiClient;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $requestTimeout = this.getRequestTimeout();
        result = result * 59 + (int)($requestTimeout >>> 32 ^ $requestTimeout);
        String $openaiApiBase = this.getOpenaiApiBase();
        result = result * 59 + ($openaiApiBase == null ? 43 : $openaiApiBase.hashCode());
        String $openaiApiKey = this.getOpenaiApiKey();
        result = result * 59 + ($openaiApiKey == null ? 43 : $openaiApiKey.hashCode());
        OpenaiApiType $openaiApiType = this.getOpenaiApiType();
        result = result * 59 + ($openaiApiType == null ? 43 : ((Object)((Object)$openaiApiType)).hashCode());
        String $openaiApiVersion = this.getOpenaiApiVersion();
        result = result * 59 + ($openaiApiVersion == null ? 43 : $openaiApiVersion.hashCode());
        String $openaiOrganization = this.getOpenaiOrganization();
        result = result * 59 + ($openaiOrganization == null ? 43 : $openaiOrganization.hashCode());
        String $openaiProxy = this.getOpenaiProxy();
        result = result * 59 + ($openaiProxy == null ? 43 : $openaiProxy.hashCode());
        String $proxyUsername = this.getProxyUsername();
        result = result * 59 + ($proxyUsername == null ? 43 : $proxyUsername.hashCode());
        String $proxyPassword = this.getProxyPassword();
        result = result * 59 + ($proxyPassword == null ? 43 : $proxyPassword.hashCode());
        List<Interceptor> $interceptorList = this.getInterceptorList();
        result = result * 59 + ($interceptorList == null ? 43 : ((Object)$interceptorList).hashCode());
        OpenAiService $service = this.getService();
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        OkHttpClient $httpClient = this.getHttpClient();
        result = result * 59 + ($httpClient == null ? 43 : $httpClient.hashCode());
        ObjectMapper $objectMapper = this.getObjectMapper();
        result = result * 59 + ($objectMapper == null ? 43 : $objectMapper.hashCode());
        return result;
    }

    public String toString() {
        return "OpenAiClient(openaiApiBase=" + this.getOpenaiApiBase() + ", openaiApiKey=" + this.getOpenaiApiKey() + ", openaiApiType=" + this.getOpenaiApiType() + ", openaiApiVersion=" + this.getOpenaiApiVersion() + ", openaiOrganization=" + this.getOpenaiOrganization() + ", openaiProxy=" + this.getOpenaiProxy() + ", proxyUsername=" + this.getProxyUsername() + ", proxyPassword=" + this.getProxyPassword() + ", requestTimeout=" + this.getRequestTimeout() + ", interceptorList=" + this.getInterceptorList() + ", service=" + this.getService() + ", httpClient=" + this.getHttpClient() + ", objectMapper=" + this.getObjectMapper() + ")";
    }

    public static class OpenAiClientBuilder {
        private String openaiApiBase;
        private String openaiApiKey;
        private boolean openaiApiType$set;
        private OpenaiApiType openaiApiType$value;
        private String openaiApiVersion;
        private String openaiOrganization;
        private String openaiProxy;
        private String proxyUsername;
        private String proxyPassword;
        private boolean requestTimeout$set;
        private long requestTimeout$value;
        private List<Interceptor> interceptorList;
        private OpenAiService service;
        private OkHttpClient httpClient;
        private ObjectMapper objectMapper;

        OpenAiClientBuilder() {
        }

        public OpenAiClientBuilder openaiApiBase(String openaiApiBase) {
            this.openaiApiBase = openaiApiBase;
            return this;
        }

        public OpenAiClientBuilder openaiApiKey(String openaiApiKey) {
            this.openaiApiKey = openaiApiKey;
            return this;
        }

        public OpenAiClientBuilder openaiApiType(OpenaiApiType openaiApiType) {
            this.openaiApiType$value = openaiApiType;
            this.openaiApiType$set = true;
            return this;
        }

        public OpenAiClientBuilder openaiApiVersion(String openaiApiVersion) {
            this.openaiApiVersion = openaiApiVersion;
            return this;
        }

        public OpenAiClientBuilder openaiOrganization(String openaiOrganization) {
            this.openaiOrganization = openaiOrganization;
            return this;
        }

        public OpenAiClientBuilder openaiProxy(String openaiProxy) {
            this.openaiProxy = openaiProxy;
            return this;
        }

        public OpenAiClientBuilder proxyUsername(String proxyUsername) {
            this.proxyUsername = proxyUsername;
            return this;
        }

        public OpenAiClientBuilder proxyPassword(String proxyPassword) {
            this.proxyPassword = proxyPassword;
            return this;
        }

        public OpenAiClientBuilder requestTimeout(long requestTimeout) {
            this.requestTimeout$value = requestTimeout;
            this.requestTimeout$set = true;
            return this;
        }

        public OpenAiClientBuilder interceptorList(List<Interceptor> interceptorList) {
            this.interceptorList = interceptorList;
            return this;
        }

        public OpenAiClientBuilder service(OpenAiService service) {
            this.service = service;
            return this;
        }

        public OpenAiClientBuilder httpClient(OkHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public OpenAiClientBuilder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public OpenAiClient build() {
            OpenaiApiType openaiApiType$value = this.openaiApiType$value;
            if (!this.openaiApiType$set) {
                openaiApiType$value = OpenAiClient.$default$openaiApiType();
            }
            long requestTimeout$value = this.requestTimeout$value;
            if (!this.requestTimeout$set) {
                requestTimeout$value = OpenAiClient.$default$requestTimeout();
            }
            return new OpenAiClient(this.openaiApiBase, this.openaiApiKey, openaiApiType$value, this.openaiApiVersion, this.openaiOrganization, this.openaiProxy, this.proxyUsername, this.proxyPassword, requestTimeout$value, this.interceptorList, this.service, this.httpClient, this.objectMapper);
        }

        public String toString() {
            return "OpenAiClient.OpenAiClientBuilder(openaiApiBase=" + this.openaiApiBase + ", openaiApiKey=" + this.openaiApiKey + ", openaiApiType$value=" + this.openaiApiType$value + ", openaiApiVersion=" + this.openaiApiVersion + ", openaiOrganization=" + this.openaiOrganization + ", openaiProxy=" + this.openaiProxy + ", proxyUsername=" + this.proxyUsername + ", proxyPassword=" + this.proxyPassword + ", requestTimeout$value=" + this.requestTimeout$value + ", interceptorList=" + this.interceptorList + ", service=" + this.service + ", httpClient=" + this.httpClient + ", objectMapper=" + this.objectMapper + ")";
        }
    }
}

