/*
 * Decompiled with CFR 0.152.
 */
package com.hw.openai.entity.chat;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hw.openai.entity.chat.Message;
import com.hw.openai.entity.chat.Tool;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ChatCompletion
implements Serializable {
    @NotBlank
    private String model;
    @NotEmpty
    private List<Message> messages;
    private float temperature;
    @JsonProperty(value="top_p")
    private float topP;
    private Integer n;
    private boolean stream;
    private Integer seed;
    private List<String> stop;
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;
    @JsonProperty(value="presence_penalty")
    private float presencePenalty;
    @JsonProperty(value="frequency_penalty")
    private float frequencyPenalty;
    @JsonProperty(value="logit_bias")
    private Map<String, Float> logitBias;
    private String user;
    private List<Tool> tools;
    @JsonProperty(value="tool_choice")
    private String toolChoice;

    private static float $default$temperature() {
        return 1.0f;
    }

    private static float $default$topP() {
        return 1.0f;
    }

    private static Integer $default$n() {
        return 1;
    }

    ChatCompletion(String model, List<Message> messages, float temperature, float topP, Integer n, boolean stream, Integer seed, List<String> stop, Integer maxTokens, float presencePenalty, float frequencyPenalty, Map<String, Float> logitBias, String user, List<Tool> tools, String toolChoice) {
        this.model = model;
        this.messages = messages;
        this.temperature = temperature;
        this.topP = topP;
        this.n = n;
        this.stream = stream;
        this.seed = seed;
        this.stop = stop;
        this.maxTokens = maxTokens;
        this.presencePenalty = presencePenalty;
        this.frequencyPenalty = frequencyPenalty;
        this.logitBias = logitBias;
        this.user = user;
        this.tools = tools;
        this.toolChoice = toolChoice;
    }

    public static ChatCompletionBuilder builder() {
        return new ChatCompletionBuilder();
    }

    public String getModel() {
        return this.model;
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public float getTopP() {
        return this.topP;
    }

    public Integer getN() {
        return this.n;
    }

    public boolean isStream() {
        return this.stream;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public List<String> getStop() {
        return this.stop;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public float getPresencePenalty() {
        return this.presencePenalty;
    }

    public float getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public Map<String, Float> getLogitBias() {
        return this.logitBias;
    }

    public String getUser() {
        return this.user;
    }

    public List<Tool> getTools() {
        return this.tools;
    }

    public String getToolChoice() {
        return this.toolChoice;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setMessages(List<Message> messages) {
        this.messages = messages;
    }

    public void setTemperature(float temperature) {
        this.temperature = temperature;
    }

    @JsonProperty(value="top_p")
    public void setTopP(float topP) {
        this.topP = topP;
    }

    public void setN(Integer n) {
        this.n = n;
    }

    public void setStream(boolean stream) {
        this.stream = stream;
    }

    public void setSeed(Integer seed) {
        this.seed = seed;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    @JsonProperty(value="max_tokens")
    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    @JsonProperty(value="presence_penalty")
    public void setPresencePenalty(float presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    @JsonProperty(value="frequency_penalty")
    public void setFrequencyPenalty(float frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    @JsonProperty(value="logit_bias")
    public void setLogitBias(Map<String, Float> logitBias) {
        this.logitBias = logitBias;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setTools(List<Tool> tools) {
        this.tools = tools;
    }

    @JsonProperty(value="tool_choice")
    public void setToolChoice(String toolChoice) {
        this.toolChoice = toolChoice;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatCompletion)) {
            return false;
        }
        ChatCompletion other = (ChatCompletion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getTemperature(), other.getTemperature()) != 0) {
            return false;
        }
        if (Float.compare(this.getTopP(), other.getTopP()) != 0) {
            return false;
        }
        if (this.isStream() != other.isStream()) {
            return false;
        }
        if (Float.compare(this.getPresencePenalty(), other.getPresencePenalty()) != 0) {
            return false;
        }
        if (Float.compare(this.getFrequencyPenalty(), other.getFrequencyPenalty()) != 0) {
            return false;
        }
        Integer this$n = this.getN();
        Integer other$n = other.getN();
        if (this$n == null ? other$n != null : !((Object)this$n).equals(other$n)) {
            return false;
        }
        Integer this$seed = this.getSeed();
        Integer other$seed = other.getSeed();
        if (this$seed == null ? other$seed != null : !((Object)this$seed).equals(other$seed)) {
            return false;
        }
        Integer this$maxTokens = this.getMaxTokens();
        Integer other$maxTokens = other.getMaxTokens();
        if (this$maxTokens == null ? other$maxTokens != null : !((Object)this$maxTokens).equals(other$maxTokens)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        List<Message> this$messages = this.getMessages();
        List<Message> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        List<String> this$stop = this.getStop();
        List<String> other$stop = other.getStop();
        if (this$stop == null ? other$stop != null : !((Object)this$stop).equals(other$stop)) {
            return false;
        }
        Map<String, Float> this$logitBias = this.getLogitBias();
        Map<String, Float> other$logitBias = other.getLogitBias();
        if (this$logitBias == null ? other$logitBias != null : !((Object)this$logitBias).equals(other$logitBias)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        List<Tool> this$tools = this.getTools();
        List<Tool> other$tools = other.getTools();
        if (this$tools == null ? other$tools != null : !((Object)this$tools).equals(other$tools)) {
            return false;
        }
        String this$toolChoice = this.getToolChoice();
        String other$toolChoice = other.getToolChoice();
        return !(this$toolChoice == null ? other$toolChoice != null : !this$toolChoice.equals(other$toolChoice));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatCompletion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getTemperature());
        result = result * 59 + Float.floatToIntBits(this.getTopP());
        result = result * 59 + (this.isStream() ? 79 : 97);
        result = result * 59 + Float.floatToIntBits(this.getPresencePenalty());
        result = result * 59 + Float.floatToIntBits(this.getFrequencyPenalty());
        Integer $n = this.getN();
        result = result * 59 + ($n == null ? 43 : ((Object)$n).hashCode());
        Integer $seed = this.getSeed();
        result = result * 59 + ($seed == null ? 43 : ((Object)$seed).hashCode());
        Integer $maxTokens = this.getMaxTokens();
        result = result * 59 + ($maxTokens == null ? 43 : ((Object)$maxTokens).hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        List<Message> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        List<String> $stop = this.getStop();
        result = result * 59 + ($stop == null ? 43 : ((Object)$stop).hashCode());
        Map<String, Float> $logitBias = this.getLogitBias();
        result = result * 59 + ($logitBias == null ? 43 : ((Object)$logitBias).hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        List<Tool> $tools = this.getTools();
        result = result * 59 + ($tools == null ? 43 : ((Object)$tools).hashCode());
        String $toolChoice = this.getToolChoice();
        result = result * 59 + ($toolChoice == null ? 43 : $toolChoice.hashCode());
        return result;
    }

    public String toString() {
        return "ChatCompletion(model=" + this.getModel() + ", messages=" + this.getMessages() + ", temperature=" + this.getTemperature() + ", topP=" + this.getTopP() + ", n=" + this.getN() + ", stream=" + this.isStream() + ", seed=" + this.getSeed() + ", stop=" + this.getStop() + ", maxTokens=" + this.getMaxTokens() + ", presencePenalty=" + this.getPresencePenalty() + ", frequencyPenalty=" + this.getFrequencyPenalty() + ", logitBias=" + this.getLogitBias() + ", user=" + this.getUser() + ", tools=" + this.getTools() + ", toolChoice=" + this.getToolChoice() + ")";
    }

    public static class ChatCompletionBuilder {
        private String model;
        private List<Message> messages;
        private boolean temperature$set;
        private float temperature$value;
        private boolean topP$set;
        private float topP$value;
        private boolean n$set;
        private Integer n$value;
        private boolean stream;
        private Integer seed;
        private List<String> stop;
        private Integer maxTokens;
        private float presencePenalty;
        private float frequencyPenalty;
        private Map<String, Float> logitBias;
        private String user;
        private List<Tool> tools;
        private String toolChoice;

        ChatCompletionBuilder() {
        }

        public ChatCompletionBuilder model(String model) {
            this.model = model;
            return this;
        }

        public ChatCompletionBuilder messages(List<Message> messages) {
            this.messages = messages;
            return this;
        }

        public ChatCompletionBuilder temperature(float temperature) {
            this.temperature$value = temperature;
            this.temperature$set = true;
            return this;
        }

        @JsonProperty(value="top_p")
        public ChatCompletionBuilder topP(float topP) {
            this.topP$value = topP;
            this.topP$set = true;
            return this;
        }

        public ChatCompletionBuilder n(Integer n) {
            this.n$value = n;
            this.n$set = true;
            return this;
        }

        public ChatCompletionBuilder stream(boolean stream) {
            this.stream = stream;
            return this;
        }

        public ChatCompletionBuilder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        public ChatCompletionBuilder stop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        @JsonProperty(value="max_tokens")
        public ChatCompletionBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        @JsonProperty(value="presence_penalty")
        public ChatCompletionBuilder presencePenalty(float presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        @JsonProperty(value="frequency_penalty")
        public ChatCompletionBuilder frequencyPenalty(float frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        @JsonProperty(value="logit_bias")
        public ChatCompletionBuilder logitBias(Map<String, Float> logitBias) {
            this.logitBias = logitBias;
            return this;
        }

        public ChatCompletionBuilder user(String user) {
            this.user = user;
            return this;
        }

        public ChatCompletionBuilder tools(List<Tool> tools) {
            this.tools = tools;
            return this;
        }

        @JsonProperty(value="tool_choice")
        public ChatCompletionBuilder toolChoice(String toolChoice) {
            this.toolChoice = toolChoice;
            return this;
        }

        public ChatCompletion build() {
            float temperature$value = this.temperature$value;
            if (!this.temperature$set) {
                temperature$value = ChatCompletion.$default$temperature();
            }
            float topP$value = this.topP$value;
            if (!this.topP$set) {
                topP$value = ChatCompletion.$default$topP();
            }
            Integer n$value = this.n$value;
            if (!this.n$set) {
                n$value = ChatCompletion.$default$n();
            }
            return new ChatCompletion(this.model, this.messages, temperature$value, topP$value, n$value, this.stream, this.seed, this.stop, this.maxTokens, this.presencePenalty, this.frequencyPenalty, this.logitBias, this.user, this.tools, this.toolChoice);
        }

        public String toString() {
            return "ChatCompletion.ChatCompletionBuilder(model=" + this.model + ", messages=" + this.messages + ", temperature$value=" + this.temperature$value + ", topP$value=" + this.topP$value + ", n$value=" + this.n$value + ", stream=" + this.stream + ", seed=" + this.seed + ", stop=" + this.stop + ", maxTokens=" + this.maxTokens + ", presencePenalty=" + this.presencePenalty + ", frequencyPenalty=" + this.frequencyPenalty + ", logitBias=" + this.logitBias + ", user=" + this.user + ", tools=" + this.tools + ", toolChoice=" + this.toolChoice + ")";
        }
    }
}

