/*
 * Decompiled with CFR 0.152.
 */
package com.hw.openai.entity.chat;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ChatFunction {
    @NotBlank
    private String name;
    private String description;
    @NotNull
    private ChatParameter parameters;

    ChatFunction(String name, String description, ChatParameter parameters) {
        this.name = name;
        this.description = description;
        this.parameters = parameters;
    }

    public static ChatFunctionBuilder builder() {
        return new ChatFunctionBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public ChatParameter getParameters() {
        return this.parameters;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setParameters(ChatParameter parameters) {
        this.parameters = parameters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatFunction)) {
            return false;
        }
        ChatFunction other = (ChatFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        ChatParameter this$parameters = this.getParameters();
        ChatParameter other$parameters = other.getParameters();
        return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatFunction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        ChatParameter $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        return result;
    }

    public String toString() {
        return "ChatFunction(name=" + this.getName() + ", description=" + this.getDescription() + ", parameters=" + this.getParameters() + ")";
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class ChatParameter {
        private String type;
        private ObjectNode properties;
        private List<String> required;

        public String getType() {
            return this.type;
        }

        public ObjectNode getProperties() {
            return this.properties;
        }

        public List<String> getRequired() {
            return this.required;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setProperties(ObjectNode properties) {
            this.properties = properties;
        }

        public void setRequired(List<String> required) {
            this.required = required;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChatParameter)) {
                return false;
            }
            ChatParameter other = (ChatParameter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            ObjectNode this$properties = this.getProperties();
            ObjectNode other$properties = other.getProperties();
            if (this$properties == null ? other$properties != null : !this$properties.equals(other$properties)) {
                return false;
            }
            List<String> this$required = this.getRequired();
            List<String> other$required = other.getRequired();
            return !(this$required == null ? other$required != null : !((Object)this$required).equals(other$required));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ChatParameter;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            ObjectNode $properties = this.getProperties();
            result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
            List<String> $required = this.getRequired();
            result = result * 59 + ($required == null ? 43 : ((Object)$required).hashCode());
            return result;
        }

        public String toString() {
            return "ChatFunction.ChatParameter(type=" + this.getType() + ", properties=" + this.getProperties() + ", required=" + this.getRequired() + ")";
        }
    }

    public static class ChatFunctionBuilder {
        private String name;
        private String description;
        private ChatParameter parameters;

        ChatFunctionBuilder() {
        }

        public ChatFunctionBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ChatFunctionBuilder description(String description) {
            this.description = description;
            return this;
        }

        public ChatFunctionBuilder parameters(ChatParameter parameters) {
            this.parameters = parameters;
            return this;
        }

        public ChatFunction build() {
            return new ChatFunction(this.name, this.description, this.parameters);
        }

        public String toString() {
            return "ChatFunction.ChatFunctionBuilder(name=" + this.name + ", description=" + this.description + ", parameters=" + this.parameters + ")";
        }
    }
}

