/*
 * Decompiled with CFR 0.152.
 */
package com.hw.openai.entity.chat;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hw.openai.entity.chat.Role;
import com.hw.openai.entity.chat.ToolCall;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Message
implements Serializable {
    @NotNull
    private Role role;
    @JsonInclude
    private String content;
    private String name;
    @JsonProperty(value="tool_calls")
    private List<ToolCall> toolCalls;

    public Message(Role role, String content) {
        this.role = role;
        this.content = content;
    }

    public Message(Role role, String content, String name) {
        this.role = role;
        this.content = content;
        this.name = name;
    }

    public static Message of(String role, String content) {
        return new Message(Role.fromValue(role), content);
    }

    public static Message of(String content) {
        return new Message(Role.USER, content);
    }

    public static Message ofSystem(String content) {
        return new Message(Role.SYSTEM, content);
    }

    public static Message ofAssistant(String content) {
        return new Message(Role.ASSISTANT, content);
    }

    public static Message ofFunction(String content, String name) {
        return new Message(Role.FUNCTION, content, name);
    }

    public static MessageBuilder builder() {
        return new MessageBuilder();
    }

    public Role getRole() {
        return this.role;
    }

    public String getContent() {
        return this.content;
    }

    public String getName() {
        return this.name;
    }

    public List<ToolCall> getToolCalls() {
        return this.toolCalls;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="tool_calls")
    public void setToolCalls(List<ToolCall> toolCalls) {
        this.toolCalls = toolCalls;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Role this$role = this.getRole();
        Role other$role = other.getRole();
        if (this$role == null ? other$role != null : !((Object)((Object)this$role)).equals((Object)other$role)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<ToolCall> this$toolCalls = this.getToolCalls();
        List<ToolCall> other$toolCalls = other.getToolCalls();
        return !(this$toolCalls == null ? other$toolCalls != null : !((Object)this$toolCalls).equals(other$toolCalls));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Message;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Role $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : ((Object)((Object)$role)).hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<ToolCall> $toolCalls = this.getToolCalls();
        result = result * 59 + ($toolCalls == null ? 43 : ((Object)$toolCalls).hashCode());
        return result;
    }

    public String toString() {
        return "Message(role=" + this.getRole() + ", content=" + this.getContent() + ", name=" + this.getName() + ", toolCalls=" + this.getToolCalls() + ")";
    }

    public Message() {
    }

    public Message(Role role, String content, String name, List<ToolCall> toolCalls) {
        this.role = role;
        this.content = content;
        this.name = name;
        this.toolCalls = toolCalls;
    }

    public static class MessageBuilder {
        private Role role;
        private String content;
        private String name;
        private List<ToolCall> toolCalls;

        MessageBuilder() {
        }

        public MessageBuilder role(Role role) {
            this.role = role;
            return this;
        }

        public MessageBuilder content(String content) {
            this.content = content;
            return this;
        }

        public MessageBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="tool_calls")
        public MessageBuilder toolCalls(List<ToolCall> toolCalls) {
            this.toolCalls = toolCalls;
            return this;
        }

        public Message build() {
            return new Message(this.role, this.content, this.name, this.toolCalls);
        }

        public String toString() {
            return "Message.MessageBuilder(role=" + this.role + ", content=" + this.content + ", name=" + this.name + ", toolCalls=" + this.toolCalls + ")";
        }
    }
}

