/*
 * Decompiled with CFR 0.152.
 */
package com.hw.openai.entity.completions;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Completion
implements Serializable {
    @NotBlank
    private String model;
    private List<String> prompt;
    private String suffix;
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;
    private float temperature;
    @JsonProperty(value="top_p")
    private float topP;
    private Integer n;
    private boolean stream;
    private Integer logprobs;
    private boolean echo;
    private List<String> stop;
    @JsonProperty(value="presence_penalty")
    private float presencePenalty;
    @JsonProperty(value="frequency_penalty")
    private float frequencyPenalty;
    @JsonProperty(value="best_of")
    private Integer bestOf;
    @JsonProperty(value="logit_bias")
    private Map<String, Float> logitBias;
    private String user;

    private static Integer $default$maxTokens() {
        return 16;
    }

    private static float $default$temperature() {
        return 1.0f;
    }

    private static float $default$topP() {
        return 1.0f;
    }

    private static Integer $default$n() {
        return 1;
    }

    private static Integer $default$bestOf() {
        return 1;
    }

    Completion(String model, List<String> prompt, String suffix, Integer maxTokens, float temperature, float topP, Integer n, boolean stream, Integer logprobs, boolean echo, List<String> stop, float presencePenalty, float frequencyPenalty, Integer bestOf, Map<String, Float> logitBias, String user) {
        this.model = model;
        this.prompt = prompt;
        this.suffix = suffix;
        this.maxTokens = maxTokens;
        this.temperature = temperature;
        this.topP = topP;
        this.n = n;
        this.stream = stream;
        this.logprobs = logprobs;
        this.echo = echo;
        this.stop = stop;
        this.presencePenalty = presencePenalty;
        this.frequencyPenalty = frequencyPenalty;
        this.bestOf = bestOf;
        this.logitBias = logitBias;
        this.user = user;
    }

    public static CompletionBuilder builder() {
        return new CompletionBuilder();
    }

    public String getModel() {
        return this.model;
    }

    public List<String> getPrompt() {
        return this.prompt;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public float getTopP() {
        return this.topP;
    }

    public Integer getN() {
        return this.n;
    }

    public boolean isStream() {
        return this.stream;
    }

    public Integer getLogprobs() {
        return this.logprobs;
    }

    public boolean isEcho() {
        return this.echo;
    }

    public List<String> getStop() {
        return this.stop;
    }

    public float getPresencePenalty() {
        return this.presencePenalty;
    }

    public float getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public Integer getBestOf() {
        return this.bestOf;
    }

    public Map<String, Float> getLogitBias() {
        return this.logitBias;
    }

    public String getUser() {
        return this.user;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setPrompt(List<String> prompt) {
        this.prompt = prompt;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    @JsonProperty(value="max_tokens")
    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public void setTemperature(float temperature) {
        this.temperature = temperature;
    }

    @JsonProperty(value="top_p")
    public void setTopP(float topP) {
        this.topP = topP;
    }

    public void setN(Integer n) {
        this.n = n;
    }

    public void setStream(boolean stream) {
        this.stream = stream;
    }

    public void setLogprobs(Integer logprobs) {
        this.logprobs = logprobs;
    }

    public void setEcho(boolean echo) {
        this.echo = echo;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    @JsonProperty(value="presence_penalty")
    public void setPresencePenalty(float presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    @JsonProperty(value="frequency_penalty")
    public void setFrequencyPenalty(float frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    @JsonProperty(value="best_of")
    public void setBestOf(Integer bestOf) {
        this.bestOf = bestOf;
    }

    @JsonProperty(value="logit_bias")
    public void setLogitBias(Map<String, Float> logitBias) {
        this.logitBias = logitBias;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Completion)) {
            return false;
        }
        Completion other = (Completion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getTemperature(), other.getTemperature()) != 0) {
            return false;
        }
        if (Float.compare(this.getTopP(), other.getTopP()) != 0) {
            return false;
        }
        if (this.isStream() != other.isStream()) {
            return false;
        }
        if (this.isEcho() != other.isEcho()) {
            return false;
        }
        if (Float.compare(this.getPresencePenalty(), other.getPresencePenalty()) != 0) {
            return false;
        }
        if (Float.compare(this.getFrequencyPenalty(), other.getFrequencyPenalty()) != 0) {
            return false;
        }
        Integer this$maxTokens = this.getMaxTokens();
        Integer other$maxTokens = other.getMaxTokens();
        if (this$maxTokens == null ? other$maxTokens != null : !((Object)this$maxTokens).equals(other$maxTokens)) {
            return false;
        }
        Integer this$n = this.getN();
        Integer other$n = other.getN();
        if (this$n == null ? other$n != null : !((Object)this$n).equals(other$n)) {
            return false;
        }
        Integer this$logprobs = this.getLogprobs();
        Integer other$logprobs = other.getLogprobs();
        if (this$logprobs == null ? other$logprobs != null : !((Object)this$logprobs).equals(other$logprobs)) {
            return false;
        }
        Integer this$bestOf = this.getBestOf();
        Integer other$bestOf = other.getBestOf();
        if (this$bestOf == null ? other$bestOf != null : !((Object)this$bestOf).equals(other$bestOf)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        List<String> this$prompt = this.getPrompt();
        List<String> other$prompt = other.getPrompt();
        if (this$prompt == null ? other$prompt != null : !((Object)this$prompt).equals(other$prompt)) {
            return false;
        }
        String this$suffix = this.getSuffix();
        String other$suffix = other.getSuffix();
        if (this$suffix == null ? other$suffix != null : !this$suffix.equals(other$suffix)) {
            return false;
        }
        List<String> this$stop = this.getStop();
        List<String> other$stop = other.getStop();
        if (this$stop == null ? other$stop != null : !((Object)this$stop).equals(other$stop)) {
            return false;
        }
        Map<String, Float> this$logitBias = this.getLogitBias();
        Map<String, Float> other$logitBias = other.getLogitBias();
        if (this$logitBias == null ? other$logitBias != null : !((Object)this$logitBias).equals(other$logitBias)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        return !(this$user == null ? other$user != null : !this$user.equals(other$user));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Completion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getTemperature());
        result = result * 59 + Float.floatToIntBits(this.getTopP());
        result = result * 59 + (this.isStream() ? 79 : 97);
        result = result * 59 + (this.isEcho() ? 79 : 97);
        result = result * 59 + Float.floatToIntBits(this.getPresencePenalty());
        result = result * 59 + Float.floatToIntBits(this.getFrequencyPenalty());
        Integer $maxTokens = this.getMaxTokens();
        result = result * 59 + ($maxTokens == null ? 43 : ((Object)$maxTokens).hashCode());
        Integer $n = this.getN();
        result = result * 59 + ($n == null ? 43 : ((Object)$n).hashCode());
        Integer $logprobs = this.getLogprobs();
        result = result * 59 + ($logprobs == null ? 43 : ((Object)$logprobs).hashCode());
        Integer $bestOf = this.getBestOf();
        result = result * 59 + ($bestOf == null ? 43 : ((Object)$bestOf).hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        List<String> $prompt = this.getPrompt();
        result = result * 59 + ($prompt == null ? 43 : ((Object)$prompt).hashCode());
        String $suffix = this.getSuffix();
        result = result * 59 + ($suffix == null ? 43 : $suffix.hashCode());
        List<String> $stop = this.getStop();
        result = result * 59 + ($stop == null ? 43 : ((Object)$stop).hashCode());
        Map<String, Float> $logitBias = this.getLogitBias();
        result = result * 59 + ($logitBias == null ? 43 : ((Object)$logitBias).hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        return result;
    }

    public String toString() {
        return "Completion(model=" + this.getModel() + ", prompt=" + this.getPrompt() + ", suffix=" + this.getSuffix() + ", maxTokens=" + this.getMaxTokens() + ", temperature=" + this.getTemperature() + ", topP=" + this.getTopP() + ", n=" + this.getN() + ", stream=" + this.isStream() + ", logprobs=" + this.getLogprobs() + ", echo=" + this.isEcho() + ", stop=" + this.getStop() + ", presencePenalty=" + this.getPresencePenalty() + ", frequencyPenalty=" + this.getFrequencyPenalty() + ", bestOf=" + this.getBestOf() + ", logitBias=" + this.getLogitBias() + ", user=" + this.getUser() + ")";
    }

    public static class CompletionBuilder {
        private String model;
        private List<String> prompt;
        private String suffix;
        private boolean maxTokens$set;
        private Integer maxTokens$value;
        private boolean temperature$set;
        private float temperature$value;
        private boolean topP$set;
        private float topP$value;
        private boolean n$set;
        private Integer n$value;
        private boolean stream;
        private Integer logprobs;
        private boolean echo;
        private List<String> stop;
        private float presencePenalty;
        private float frequencyPenalty;
        private boolean bestOf$set;
        private Integer bestOf$value;
        private Map<String, Float> logitBias;
        private String user;

        CompletionBuilder() {
        }

        public CompletionBuilder model(String model) {
            this.model = model;
            return this;
        }

        public CompletionBuilder prompt(List<String> prompt) {
            this.prompt = prompt;
            return this;
        }

        public CompletionBuilder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        @JsonProperty(value="max_tokens")
        public CompletionBuilder maxTokens(Integer maxTokens) {
            this.maxTokens$value = maxTokens;
            this.maxTokens$set = true;
            return this;
        }

        public CompletionBuilder temperature(float temperature) {
            this.temperature$value = temperature;
            this.temperature$set = true;
            return this;
        }

        @JsonProperty(value="top_p")
        public CompletionBuilder topP(float topP) {
            this.topP$value = topP;
            this.topP$set = true;
            return this;
        }

        public CompletionBuilder n(Integer n) {
            this.n$value = n;
            this.n$set = true;
            return this;
        }

        public CompletionBuilder stream(boolean stream) {
            this.stream = stream;
            return this;
        }

        public CompletionBuilder logprobs(Integer logprobs) {
            this.logprobs = logprobs;
            return this;
        }

        public CompletionBuilder echo(boolean echo) {
            this.echo = echo;
            return this;
        }

        public CompletionBuilder stop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        @JsonProperty(value="presence_penalty")
        public CompletionBuilder presencePenalty(float presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        @JsonProperty(value="frequency_penalty")
        public CompletionBuilder frequencyPenalty(float frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        @JsonProperty(value="best_of")
        public CompletionBuilder bestOf(Integer bestOf) {
            this.bestOf$value = bestOf;
            this.bestOf$set = true;
            return this;
        }

        @JsonProperty(value="logit_bias")
        public CompletionBuilder logitBias(Map<String, Float> logitBias) {
            this.logitBias = logitBias;
            return this;
        }

        public CompletionBuilder user(String user) {
            this.user = user;
            return this;
        }

        public Completion build() {
            Integer maxTokens$value = this.maxTokens$value;
            if (!this.maxTokens$set) {
                maxTokens$value = Completion.$default$maxTokens();
            }
            float temperature$value = this.temperature$value;
            if (!this.temperature$set) {
                temperature$value = Completion.$default$temperature();
            }
            float topP$value = this.topP$value;
            if (!this.topP$set) {
                topP$value = Completion.$default$topP();
            }
            Integer n$value = this.n$value;
            if (!this.n$set) {
                n$value = Completion.$default$n();
            }
            Integer bestOf$value = this.bestOf$value;
            if (!this.bestOf$set) {
                bestOf$value = Completion.$default$bestOf();
            }
            return new Completion(this.model, this.prompt, this.suffix, maxTokens$value, temperature$value, topP$value, n$value, this.stream, this.logprobs, this.echo, this.stop, this.presencePenalty, this.frequencyPenalty, bestOf$value, this.logitBias, this.user);
        }

        public String toString() {
            return "Completion.CompletionBuilder(model=" + this.model + ", prompt=" + this.prompt + ", suffix=" + this.suffix + ", maxTokens$value=" + this.maxTokens$value + ", temperature$value=" + this.temperature$value + ", topP$value=" + this.topP$value + ", n$value=" + this.n$value + ", stream=" + this.stream + ", logprobs=" + this.logprobs + ", echo=" + this.echo + ", stop=" + this.stop + ", presencePenalty=" + this.presencePenalty + ", frequencyPenalty=" + this.frequencyPenalty + ", bestOf$value=" + this.bestOf$value + ", logitBias=" + this.logitBias + ", user=" + this.user + ")";
        }
    }
}

