/*
 * Decompiled with CFR 0.152.
 */
package com.hw.openai.entity.embeddings;

import com.fasterxml.jackson.annotation.JsonInclude;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Embedding
implements Serializable {
    @NotBlank
    private String model;
    @NotEmpty
    private List<?> input;
    private String user;

    Embedding(String model, List<?> input, String user) {
        this.model = model;
        this.input = input;
        this.user = user;
    }

    public static EmbeddingBuilder builder() {
        return new EmbeddingBuilder();
    }

    public String getModel() {
        return this.model;
    }

    public List<?> getInput() {
        return this.input;
    }

    public String getUser() {
        return this.user;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setInput(List<?> input) {
        this.input = input;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Embedding)) {
            return false;
        }
        Embedding other = (Embedding)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        List<?> this$input = this.getInput();
        List<?> other$input = other.getInput();
        if (this$input == null ? other$input != null : !((Object)this$input).equals(other$input)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        return !(this$user == null ? other$user != null : !this$user.equals(other$user));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Embedding;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        List<?> $input = this.getInput();
        result = result * 59 + ($input == null ? 43 : ((Object)$input).hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        return result;
    }

    public String toString() {
        return "Embedding(model=" + this.getModel() + ", input=" + this.getInput() + ", user=" + this.getUser() + ")";
    }

    public static class EmbeddingBuilder {
        private String model;
        private List<?> input;
        private String user;

        EmbeddingBuilder() {
        }

        public EmbeddingBuilder model(String model) {
            this.model = model;
            return this;
        }

        public EmbeddingBuilder input(List<?> input) {
            this.input = input;
            return this;
        }

        public EmbeddingBuilder user(String user) {
            this.user = user;
            return this;
        }

        public Embedding build() {
            return new Embedding(this.model, this.input, this.user);
        }

        public String toString() {
            return "Embedding.EmbeddingBuilder(model=" + this.model + ", input=" + this.input + ", user=" + this.user + ")";
        }
    }
}

