/*
 * Decompiled with CFR 0.152.
 */
package com.hw.openai.function;

import com.hw.openai.utils.JsonUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class FunctionExecutor {
    private static final Map<String, Function<?, ?>> FUNCTION_MAP = new HashMap(16);

    public static <T> void register(String functionName, Function<T, ?> function) {
        FUNCTION_MAP.put(functionName, function);
    }

    public static <T, R> R execute(String functionName, Class<T> clazz, String arguments) throws ClassCastException {
        Function<?, ?> function = FUNCTION_MAP.get(functionName);
        if (function == null) {
            throw new IllegalArgumentException("No function registered with name: " + functionName);
        }
        T input = JsonUtils.convertFromJsonStr(arguments, clazz);
        return (R)function.apply(input);
    }
}

